#include <stdio.h>
#include <Windows.h>
#include "DPhyGenCtlRPCIF.h"

void* client;

void PrintResult(int rc)
{
	char* errMsg;
	char* statusMsg;

	printf("Return code = %d\n", rc);
	statusMsg = GetLastStatusMsg(client, false);
	errMsg = GetLastErrMsg(client, false);
	if (statusMsg[0] != 0) printf("StatusMsg = %s\n", statusMsg);
	if (errMsg[0] != 0) printf("ErrMsg = %s\n", statusMsg);

	//  Note: don't need to free messages because "copy" argument was false
	//	Free(client, errMsg);
	//	Free(client, statusMsg);
}

int main()
{
	int rc;

	InitDLL();

	client = NewClient();
	rc = Connect(client, "", 2799);

	printf("Setting DSI standard...\n");
	rc = RPCCmdI(client, RPCCmds.SET_MIPI_STANDARD, RPCDefs.STD_DSI);
	PrintResult(rc);

	printf("Setting lane count to 1...\n");
	rc = RPCCmdI(client, RPCCmds.SET_LANE_CNT, 1);
	PrintResult(rc);

	printf("Selecting 640x480 timing configuration...\n");
	rc = RPCCmdS(client, RPCCmds.SELECT_TIMING_CONFIG, "640x480p");
	PrintResult(rc);

	printf("Sending video-mode frame...\n");
	rc = MIPICmd(client, RPCDefs.PACKED_PIXEL_STREAM_888, 0, false, 0, 0, 1, 0, 0, "ramp", NULL, 0);
	PrintResult(rc);

	Sleep(5000);

	printf("Stopping PG...\n");
	rc = RPCCmd(client, RPCCmds.STOP_PG);
	PrintResult(rc);

	printf("Enabling event timeout...\n");
	rc = RPCCmdII(client, RPCCmds.SET_OPTION, RPCDefs.OPT_DISABLE_EVENT_TIMEOUT, 0);
	PrintResult(rc);

	printf("Disabling loop commands...\n");
	rc = RPCCmdII(client, RPCCmds.SET_OPTION, RPCDefs.OPT_LOOP_COMMANDS, 0);
	PrintResult(rc);

	printf("Sending generic read request...\n");
	rc = MIPICmd(client, RPCDefs.GENERIC_READ_REQUEST, 0, true, 0, 0, 100, 0, 0, "ramp", NULL, 0);
	PrintResult(rc);

	int* respVal;
	int respValLen;
	printf("Getting DUT Response...\n");
	rc = RPCQueryRetIA(client, RPCCmds.GET_DUT_RESPONSE, &respVal, &respValLen);
	PrintResult(rc);
	if (respValLen > 0) 
	{
		int i;
		printf("Response length = %d\nResponse data => ", respValLen);
		for (i = 0; i < respValLen; i++) 
			printf("0x%2x ", respVal[i]);
		printf("\n");
	}

	printf("Press return to exit...");
	char c;
	getc(stdin);


    return 0;
}

