#ifndef DPhyGenCtlRPCIF_h
#define DPhyGenCtlRPCIF_h

typedef void*(*FuncNewClient)();
typedef int(*FuncConnect)(void* client, const char* hostName, int port);
typedef char*(*FuncGetS)(void* client, bool copy);
typedef char*(*FuncFree)(void* client, void* str);
typedef int(*FuncRPCCmd)(void* client, int cmdCode);
typedef int(*FuncRPCCmdI)(void* client, int cmdCode, int arg1);
typedef int(*FuncRPCCmdF)(void* client, int cmdCode, float arg1);
typedef int(*FuncRPCCmdS)(void* client, int cmdCode, char* arg1);
typedef int(*FuncRPCCmdII)(void* client, int cmdCode, int arg1, int arg2);
typedef int(*FuncRPCCmdIF)(void* client, int cmdCode, int arg1, float arg2);
typedef int(*FuncRPCCmdIS)(void* client, int cmdCode, int arg1, char* arg2);
typedef int(*FuncRPCCmdIII)(void* client, int cmdCode, int arg1, int arg2, int arg3);
typedef int(*FuncRPCCmdIIS)(void* client, int cmdCode, int arg1, int arg2, char* arg3);
typedef int(*FuncRPCCmdSIS)(void* client, int cmdCode, char* arg1, int arg2, char* arg3);
typedef int(*FuncRPCCmdIIBA)(void* client, int cmdCode, int arg1, int arg2, unsigned char* arg3, int arg3Len);
typedef int(*FuncRPCCmdIISS)(void* client, int cmdCode, int arg1, int arg2, char* arg3, char* arg4);
typedef int(*FuncRPCCmdSISI)(void* client, int cmdCode, char* arg1, int arg2, char* arg3, int arg4);
typedef int(*FuncRPCQueryIRetS)(void* client, int cmdCode, int arg1, char** respVal, int* respValLen);
typedef int(*FuncRPCQuerySRetS)(void* client, int cmdCode, char* arg1, char** respVal, int* respValLen);
typedef int(*FuncRPCQueryRetBA)(void* client, int cmdCode, char** respVal, int* respValLen);
typedef int(*FuncRPCQueryRetIA)(void* client, int cmdCode, int** respVal, int* respValLen);
typedef int(*FuncMIPICmd)(void* client, int cmdCode, int DCSCmdCode, bool BTA, int DTMode,
	int VC, int arg1, int arg2, int arg3, const char* fn,
	char* data, int dataLen);

class RPCErrsClass
{
public:
    const int FAIL = -1;
    const int UNKNOWN_CMD = -3;
    const int NOT_LICENSED = -6;
    const int ARGTYPE_MISMATCH = -7;

    const int USB_OPEN_FAILED = -100;
    const int DEVICE_NOT_PRESENT = -101;
    const int USB_TIMEOUT = -102;
    const int MAX_LEN_EXCEEDED = -103;
    const int CANT_OPEN_FILE = -104;
    const int FILE_DOESNT_EXIST = -105;
    const int FILE_TOO_SHORT = -106;
    const int IO_ERROR = -107;
    const int INVALID_PARAM = -108;
    const int BAD_RBF_FILE_LEN = -109;
    const int BAD_MAGIC_NUMBER = -110;
    const int DDRBW_FIFO_OVERFLOW = -111;
    const int DDRBW_DID_NOT_COMPLETE = -112;
    const int VERIFY_FAILED = -113;
    const int ABORT = -114;
    const int TIMEOUT = -115;
    const int CANT_ACQUIRE_SEMA = -116;
    const int NO_PROGSTATE_DEFINED = -117;
    const int BAD_SERIAL_NUMBER = -118;
    const int BAD_FIRMWARE_FILE_LEN = -119;
    const int BAD_SECURITY_FILE = -120;
    const int INVALID_FIRMWARE_FILE = -121;
    const int FLASH_VERIFY_ERROR = -122;
    const int CAPT_STATE_MISMATCH = -123;
    const int NO_CONNECTION = -124;
    const int REMOTE_PG_CALL_FAILED = -125;
    const int BAD_FRAME_PARAMETERS = -126;
    const int BAD_LINE_TIME = -127;
    const int INVALID_SYNC_LINE_CNT = -128;
    const int INVALID_ACTIVE_PIX_CNT = -129;
    const int INVALID_HEIGHT_OR_WIDTH = -130;
    const int CANT_CONFIGURE_P375 = -131;
    const int PG_IS_RUNNING = -132;
    const int INSUFFICIENT_PG_MEMORY = -133;
    const int THREAD_IS_BUSY = -134;
    const int INVALID_TIMING_PARAM = -136;
    const int INVALID_HSYNC_PARAM = -137;
    const int INVALID_HFRONTPORCH_PARAM = -138;
    const int INVALID_HBACKPORCH_PARAM = -139;
    const int AGGREGATE_HS_PKT_LANE_MISMATCH = -140;
    const int NO_BLANKING_ADJ = -141;
    const int HSA_TOO_SHORT = -142;
    const int HBP_TOO_SHORT = -143;
    const int HFP_TOO_SHORT = -144;
    const int MAX_PAYLOAD_EXCEEDED = -145;
    const int TEST_DID_NOT_COMPLETE = -146;
    const int SESSION_EXPIRED = -148;
    const int INVALID_VBACKPORCH_PARAM = -152;
    const int BAD_HS_MODE = -153;
    const int BAD_LP_REPL = -154;
    const int SEG_UNALIGNED = -155;
    const int INSERTION_CODE_NOT_FOUND = -161;
    const int INSERTION_CMD_TOO_LONG = -162;
    const int BTA_TIMEOUT = -163;
    const int CANT_LOCK_HS_PLL = -166;
    const int INVALID_HS_BITRATE = -169;
    const int CANT_RESTART = -170;
    const int PARSE_ERR = -172;
    const int UNKNOWN_MIPI_CMD = -173;
    const int NEED_START_EDIT_CMD = -174;
    const int CONTROL_IS_DISABLED = -175;
    const int UNEXPECTED_ARG_TYPE = -176;
    const int PAYLOAD_TOO_SHORT = -177;
    const int CMD_STANDARD_MISMATCH = -178;
    const int UNKNOWN_DCS_CMD = -180;
    const int CANT_PARTITION_FILE_CMD = -181;
    const int LP_DELAY_TOO_LONG = -182;
    const int INSERTION_BLOCK_TOO_LONG = -183;
    const int TOO_FEW_TOKENS = -191;
    const int VALUE_OUT_OF_RANGE = -192;
    const int OBJECT_NOT_FOUND = -193;
    const int USER_CANCELED = -194;
    const int BLANKING_SEGMENT_TOO_SHORT = -199;
    const int BLANKING_SEGMENT_TOO_LONG = -205;
    const int INVALID_VACTIVE_PARAM = -206;
    const int INVALID_VFRONTPORCH_PARAM = -207;
    const int UNEXPECTED_PG_COUNT = -208;

    const int PORT_IS_UNAVAILABLE = -300;
    const int CANT_PARSE_VALUE = -305;
    const int NOT_BINARY_GEN_FILE = -310;
    const int INVALID_EEPROM_VALUE = -311;
    const int SILENT_ERROR = -999;

    const int LOCAL_FAILURE = -5000;
};

class RPCCmdsClass
{
public:
    ////////////////////////////////////////////////////
    // command management
    ////////////////////////////////////////////////////

    const int SEND_MIPI_CMD = 1;

    // Create a named command in the application
    // (Will delete an existing command by the same name if it exists)
    // (If sent while defining macro, only names the component 
    // command being added to macro)
    // Uses same arguments as SEND_MIPI_CMD with one additional argument (first argument)
    // First argument: command name (string)
    const int ADD_MIPI_CMD = 0x2;

    const int SEND_IMPAIRED_MIPI_CMD = 4;

    // arg1: Cmd name (string)
    // sends the (already defined) named command given its Cmd name, as if sent from the GUI
    const int SEND_NAMED_CMD_FROM_NAME = 5;

    // arg1: Cmd index (integer)
    // sends the (already defined) named command given its Cmd index, as if sent from the GUI
    const int SEND_NAMED_CMD_FROM_INDEX = 6;

    // Deletes a named command in the application
    // arg1: command name (string)
    const int DELETE_NAMED_CMD = 7;

    // Deletes all named commands in the application
    // no arguments
    const int DELETE_ALL_NAMED_CMDS = 8;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_SORT_CMDS = 9;

    // no arguments, returns number of named Cmds defined (integer)
    const int GET_NAMED_CMD_COUNT = 10;

    // arg1: Cmd index (integer)
    // returns the Cmd name associated with the given Cmd index (string)
    const int GET_NAMED_CMD_NAME = 11;

    // arg1: command name (string)
    // selects the named command in the GUI Cmd list
    const int SELECT_NAMED_CMD = 12;

    // Uses same arguments as SEND_IMPAIRED_MIPI_CMD with one additional argument (first argument)
    // First argument: command name (string)
    const int ADD_IMPAIRED_MIPI_CMD = 13;

    ////////////////////////////////////////////////////
    // instrument configuration commands
    ////////////////////////////////////////////////////

    // arg1 = mode (DT_HS, DT_LP, DT_DEFAULT)
    const int SET_DT_MODE = 0x101;

    // arg1 = LP_FREQ (float, Hz, 0.2 - 30 MHz)
    const int SET_LP_FREQ = 0x102;

    // arg1 = HS_BIT_RATE (float, sym/sec, 23.44 to 6000 Msps)
    const int SET_HS_BIT_RATE = 0x103;

    // arg1 = lane count (int, 1-4)
    const int SET_LANE_CNT = 0x104;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_FORCE_TEST_PATTERN = 0x105;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_ALL_HS_VOLT_COMMON = 0x106;

    // arg1 = channel (int, 0-4, clk == 4)
    // arg2 = voltage (float, volts, -0.6 to 1.2 V)
    const int SET_HS_LOW_VOLT = 0x107;
    const int SET_HS_HIGH_VOLT = 0x108;

    // arg1 = voltage (float, volts, -0.28 to 1.8 V)
    const int SET_LP_LOW_VOLT = 0x109;
    const int SET_LP_HIGH_VOLT = 0x10a;

    // arg1 = lane (int, 0-4, clk == 4)
    // arg2 = delay (float, sec)
    const int SET_LANE_DELAY = 0x10b;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_AUTO_SET_CLOCK_DELAY = 0x10c;

    // arg1 = voltage (float, volts, 0.0 to 1.0 V)
    const int SET_LP_LOW_CONT_THRESH = 0x10d;
    const int SET_LP_HIGH_CONT_THRESH = 0x10e;

    // arg1 = time (float, sec, 0.1 to 100 ms)
     const int SET_BTA_WAIT_TIME = 0x10f;

    // arg1 = time (float, sec, 0.1 us to 100 ms)
    const int SET_TRIG_PULSE_WIDTH = 0x110;

    // arg1 = lane map 
    // laneMap[3..0] represents the source lane to use for phy lane 0
    // laneMap[7..4] represents the source lane to use for phy lane 1
    // laneMap[11..8] represents the source lane to use for phy lane 2
    // laneMap[15..12] represents the source lane to use for phy lane 3
    // laneMap[19..16] represents the source lane to use for the clock lane
    // Use lane = 4 for clock lane
    // Example, unity mapping is: 43210h
    const int SET_LANE_MAP = 0x111;

    // arg1 = 0 == master; 1 == slave; 2 == master/slave
    const int SET_ACTIVE_LINKS = 0x113;

    // arg1 = 0 == disable, 1 == enable
    const int SET_LINK_TO_SLAVE = 0x114;

    // arg = preemphasis (int, 0-4095)
    const int SET_PREEMPHASIS = 0x115;

    // no arguments								 
    // bracket any instrument configuration calls with START_EDIT_CONFIG/END_EDIT_CONFIG
    const int START_EDIT_CONFIG = 0x160;

    // no arguments
    // initializes instrument with new configuration settings
    const int END_EDIT_CONFIG = 0x161;


    ////////////////////////////////////////////////////
    // timing configuration commands
    ////////////////////////////////////////////////////

    // arg1 = UI (int)
    const int SET_TIMING_SKEW_CAL_UI = 0x17e;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_TIMING_ENABLE_SKEW_CAL = 0x17f;

    // arg1 = pixel count (int)
    const int SET_TIMING_HSYNC = 0x181;
    const int SET_TIMING_HBPORCH = 0x182;
    const int SET_TIMING_HFPORCH = 0x183;
    const int SET_TIMING_HACTIVE = 0x184;

    // arg1 = line count (int)
    const int SET_TIMING_VSYNC = 0x185;
    const int SET_TIMING_VBPORCH = 0x186;
    const int SET_TIMING_VFPORCH = 0x187;
    const int SET_TIMING_VACTIVE = 0x188;

    // arg1 = line time (float, sec)
    const int SET_TIMING_LINE_TIME = 0x189;

    // arg1 = pixel clock frequency (float, Hz)
    const int SET_TIMING_PIX_CLK = 0x18a;

    // arg1 = frame rate (float, Hz)
    const int SET_TIMING_FRAME_RATE = 0x18b;

    // arg1 = HS Bit Rate (float, Hz)
    const int SET_TIMING_HS_BIT_RATE = 0x19b;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_TIMING_ENABLE_DSI_PULSE_MODE = 0x18c;
    const int SET_TIMING_ENABLE_DSI_BURST_MODE = 0x18d;
    const int SET_TIMING_ENABLE_CSI_LSLE_MODE = 0x18e;
    const int SET_TIMING_ENABLE_CSI_FRAME_NUMBERING = 0x18f;
    const int SET_TIMING_ENABLE_CSI_LINE_NUMBERING = 0x190;

    // arg1 = blanking mode (AUTO_BLANK_MODE, HS_BLANK_MODE, LP11_BLANK_MODE)
    const int SET_TIMING_HSYNC_BLANKING_MODE = 0x191;
    const int SET_TIMING_HBPORCH_BLANKING_MODE = 0x192;
    const int SET_TIMING_HFPORCH_BLANKING_MODE = 0x193;
    const int SET_TIMING_VERTICAL_BLANKING_MODE = 0x194;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_TIMING_TOP_FIELD_FIRST = 0x195;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_TIMING_CLK_ON_OFF_DURING_LP11_BLANKING = 0x19c;

    // arg1 = 3D parameter number (int, PARAM_3D_x defines)
    // arg2 = 3D parameter value (int)
    const int SET_3D_PARAMETER = 0x19d;

    // arg1 = timing master (int, MASTER_x defines)
    const int SET_TIMING_MASTER = 0x19e;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_ADVANCE_FRAME_ON_EXTERNAL_EVENT = 0x19f;

    // arg1 = timing configuration name (string)
    const int SELECT_TIMING_CONFIG = 0x196;

    // arg1 = timing configuration name (string)
    const int SAVE_TIMING_CONFIG = 0x197;

    // arg1 = timing configuration name (string)
    const int DELETE_TIMING_CONFIG = 0x198;

    // no arguments
    const int DELETE_ALL_TIMING_CONFIGS = 0x199;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_SORT_TIMING_CONFIGS = 0x19a;

    // used: 0x19b, 0x19c, 0x19d, 0x19e, 0x19f

    // arg1 = 0 (disable), 1 (enable)
    const int SET_TIMING_ENABLE_CONTINUOUS_MODE = 0x1d0;

    // arg1 = DSC configuration name (string)
    const int SELECT_DSC_CONFIG = 0x1a0;

    // arg1 = DSC configuration name (string)
    const int SAVE_DSC_CONFIG = 0x1a1;

    // arg1 = DSC configuration name (string)
    const int DELETE_DSC_CONFIG = 0x1a2;

    // no arguments
    const int DELETE_ALL_DSC_CONFIGS = 0x1a3;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_SORT_DSC_CONFIGS = 0x1a4;

    // arg1 = field value (int)
    const int SET_DSC_SLICE_WIDTH = 0x1a5;
    const int SET_DSC_SLICE_HEIGHT = 0x1a6;
    const int SET_DSC_ENABLE_422 = 0x1a7;
    const int SET_DSC_USE_YUV_INPUT = 0x1a8;
    const int SET_DSC_USE_BLOCK_PREDICTION = 0x1a9;
    const int SET_DSC_ONE_CHUNK_PER_PACKET = 0x1aa;

    // arg1 = configuration filename (string)
    const int SET_DSC_CONFIG_FILENAME = 0x1ab;

    // arg1 = source filename (string)
    // arg2 = DSC filename (string)
    const int DSC_COMPRESS_FILE = 0x1ac;

    // arg1 = DSC filename (string)
    // arg2 = source filename (string)
    const int DSC_UNCOMPRESS_FILE = 0x1ad;

    // arg1 = DUAL_IF_x defines
    const int SET_DUAL_INTERFACE_MODE = 0x1ae;

    // arg1 = field value (int, 0 = false, 1 == true)
    // (SET_DSC_ENABLE_SIMPLE_422 is alias for SET_DSC_ENABLE_422 
    // which is deprecated for DSC 1.2)
    const int SET_DSC_ENABLE_SIMPLE_422 = 0x1a7;
    const int SET_DSC_ENABLE_NATIVE_422 = 0x1af;
    const int SET_DSC_ENABLE_NATIVE_420 = 0x1f0;
    const int SET_DSC_USE_REC_709 = 0x1f1;
    const int SET_DSC_VERSION_12 = 0x1f2;

    ////////////////////////////////////////////////////
    // DPhy Timing configuration commands
    ////////////////////////////////////////////////////

    // arg1 = parameter (DPHY_PARAM_* definition)
    // arg2 = nsValue (int)
    // arg3 = UIValue (int)
    // arg4 = TLPXValue (int)
    const int SET_DPHY_PARAMETER = 0x201;

    // arg1 = DPhy configuration name (string)
    const int SELECT_DPHY_CONFIG = 0x207;

    // arg1 = DPhy configuration name (string)
    const int SAVE_DPHY_CONFIG = 0x208;

    // arg1 = DPhy configuration name (string)
    const int DELETE_DPHY_CONFIG = 0x209;

    // no arguments
    const int DELETE_ALL_DPHY_CONFIGS = 0x20a;

    // arg1 = 0 (disable), 1 (enable)
    const int SET_SORT_DPHY_CONFIGS = 0x20b;

    ////////////////////////////////////////////////////
    // macro defintion
    ////////////////////////////////////////////////////

    // no arguments; puts PGRemote in macro mode (discarding previous macro)
    // any (non-video) MIPI_CMDs sent will append to current macro
    const int START_MACRO = 0x280;

    // Create a named macro in the application
    // (Deletes an existing macro by the same name if it exists)
    // arg1: macro name (string)
    const int END_MACRO = 0x281;

    // Ends and sends the current macro (must still be in macro_mode).  Macro is discarded.
    const int SEND_MACRO = 0x282;

    // Measures the current macro (must still be in macro_mode).  Macro is discarded
    const int MEASURE_MACRO = 0x283;

    // arg1: zero-based component command index (int)
	// arg2: component command name (string)
    const int RENAME_MACRO_COMPONENT_COMMAND = 0x284;

    ////////////////////////////////////////////////////
    // status commands
    ////////////////////////////////////////////////////

    // no arguments; returns 0 (not connected), 1 (connected), <0 (error)
    const int IS_INST_CONNECTED = 0x300;

    // no arguments; returns 0 (not running), 1 (running), <0 (error)
    const int IS_PROGRAM_RUNNING = 0x301;

    // no arguments; returns contention mask, <0 (error)
    // mask consists of six bits {CTN_LP0L, CTN_LP1L, CTN_LP0H, CTN_LP1H}
    const int GET_LP_CONTENTION = 0x302;

    // no arguments
    const int RESET_LP_CONTENTION = 0x303;

    // no arguments
    // returns integer array of captured data
    // Flags in data: 0x100 = START_BURST, 0x200 = END_BURST
    // START_BURST data contains first 2 escape entry bits (should always be b"01")
    // END_BURST data contains partial byte bits followed by return BTA (should always be b"11")
    // END_BURST data also contains # of valid bits - 1 in D[12..10]
    const int GET_DUT_RESPONSE = 0x304;

    // arg1 = fileName: name of file to save DUT response data as text data
    // arg2 = appendFlag (integer): set to non-zero to append to file
    // arg3 = commentString: comment to save with response; set to "" for no comment
    const int SAVE_DUT_RESPONSE = 0x305;

    // no arguments, returns inputState[1..0] (integer)
    const int GET_INST_GP_INPUT_STATE = 0x306;

    // arg1: fileName: name of file to save PG event state as integer value
    // arg2: appendFlag (integer): set to non-zero to append to file
    // arg3: commentString: comment to save with response; set to "" for no comment        
    const int SAVE_INST_GP_INPUT_STATE = 0x307;

    ////////////////////////////////////////////////////
    // frame buffer commands
    ////////////////////////////////////////////////////

    // arg1: buffer number, (integer, 0-3)
    // arg2: dataType specifying video format that will be used with this frame (integer)
    // arg3: file name (string)
    // Loads the frame from the given file, converts to the given video format, and stores
    //  into the given frame buffer number (use DEALLOC_FRAME to deallocate when done)
    const int LOAD_FRAME = 0x380;

    // arg1: buffer number, (integer, 0-3)
    // Deallocates the frame stored in the given frame buffer
    const int DEALLOC_FRAME = 0x381;

    ////////////////////////////////////////////////////
    // WriteMemory configuration commands
    ////////////////////////////////////////////////////

    // arg1 = maximum number of bytes per DCS WriteMemory partition
    const int SET_WM_PARTITION_LENGTH = 0x3a0;

    // arg1 = LP11 time between DCS WriteMemory partitions (float, sec)
    const int SET_WM_PARTITION_INTERVAL = 0x3a1;

    // arg1 = DCS WriteMemory BMP decode format (FMT_xxx)
    const int SET_WM_IMAGE_DECODE_FORMAT = 0x3a2;

    // arg1 = DCS WriteMemory RGB bit order (WM_BIT_ORDER_xxx)
    const int SET_WM_RGB_BIT_ORDER = 0x3a3;

    ////////////////////////////////////////////////////
    // RPC commands
    ////////////////////////////////////////////////////

    // arg1: Cmd name (string)
    // returns the RPC string associated with the given Cmd name (string)
    const int GET_RPC_CMD_STRING_FROM_NAME = 0x400;

    // arg1: Cmd index (integer)
    // returns the RPC string associated with the given Cmd index (string)
    const int GET_RPC_CMD_STRING_FROM_INDEX = 0x401;

    // arg1: RPC command string (string)
    // executes the given RPC command string
    // the string may have multiple RPC commands separated by <CR><LF> or <CR>
    // (all rules of RPC script files can be followed)
    const int EXECUTE_RPC_CMD_STRING = 0x402;

    ////////////////////////////////////////////////////
    // options
    ////////////////////////////////////////////////////

    // arg1 = option (OPT_XXX defines)
    // arg2 = 0 (disable), 1 (enable)
    const int SET_OPTION = 0x480;

    // arg1 = standard (STD_DSI, STD_CSI)
    const int SET_MIPI_STANDARD = 0x481;

    // Sets the Bayer encode type for CSI RAW images (when Bayer encoding is enabled)
    // arg1: string representing bayer format 
    // ("GRBG", "RGGB", "BGGR", "GBRG")
    const int SET_BAYER_ENCODE_TYPE = 0x482;

    // arg1 = option (OPT_XXX defines)
    // returns the option setting: 0 (disabled), 1 (enabled)
    const int GET_OPTION = 0x483;

    // arg1 = loop count (integer, 0 for infinite)
    // note: does not automatically enable looping
    // (use OPT_LOOP_COMMANDS to enable looping)
    const int SET_LOOP_COUNT = 0x484;

    ////////////////////////////////////////////////////
    // other commands
    ////////////////////////////////////////////////////

    // arg1 = P344 serial number
    const int INST_CONNECT = 0x500;

    // no arguments
    const int INST_DISCONNECT = 0x501;


    // arg1 = user message string enclosed in double-quotes 
    // displays message box to user with OK button (no timeout)
    const int USER_WAIT = 0x502;

    // no arguments
    const int STOP_PG = 0x503;
    const int RESTART_PG = 0x504;

    // Loads the button and command configuration from the given configuration file.
    // arg1: configuration file name (string)
    const int LOAD_CONFIG = 0x505;

    // Saves the current button and command configuration to the given configuration file.
    // arg1: configuration file name (string)
    const int SAVE_CONFIG = 0x506;

    // Assigns command to a button in the application
    // (Will replace an existing button assignment, use "" to unassign)
    // (use button page = -1 for all pages, e.g. for group unassignment)
    // (use button number = -1 for all buttons on page, e.g. for group unassignment)
    // arg1: button page (0-3, int)
    // arg2: button number in page (0-29, int)
    // arg3: command name (string)
    // arg4: tooltip (string)
    const int ASSIGN_BUTTON = 0x507;

    // Writes current state as a RPC commands to the given script filename
    // (overwrites existing file)
    // arg1: script file name (string)
    const int WRITE_CURRENT_STATE = 0x508;

    // Asserts TrigOut on instrument
    // 
    // NOTE: this is for immediate probe trigger control;
    // (use ASSERT_TRIG command to set TrigOut from MIPI stream)
    // arg1 = trigger command: 0 (low), 1 (high), 
    //                         2 (toggle), 3 (pulse)
    // Use SET_TRIG_PULSE_WIDTH to set the pulse width
    const int FORCE_TRIG = 0x509;

    const int COMPUTE_CRC = 0x50a;
    const int COMPUTE_ECC = 0x50b;

    // arg1: local/master (0), slave (1)
    const int SET_RPC_TARGET = 0x50c;

    // arg1: RPC port number (int), set to zero to un-sync
    // arg2: slave instrument serial number (0 for offline)
    const int SYNC_WITH_SLAVE = 0x50d;

    // arg1: 0 == hide, 1 == show
    const int SHOW_SLAVE_GUI = 0x50e;

    // arg1 == 0 = hide, 1 == show 
    const int SHOW_GUI = 0x50f;
};

class RPCDefsClass
{
public:
    // WriteMemory RGB Bit Order
    const int WM_BIT_ORDER_LEGACY = 0;
    const int WM_BIT_ORDER_DCS_ANNEX_A = 1;

    // Dual-interface image modes
    const int DUAL_IF_MODE_CLONE_IMAGE = 0;
    const int DUAL_IF_MODE_DUAL_IMAGE = 1;
    const int DUAL_IF_MODE_LEFT_RIGHT_IMAGE = 2;
    const int DUAL_IF_MODE_EVEN_ODD_PIXEL = 3;

    // Active Links
    const int ACTIVE_MASTER = 0;
    const int ACTIVE_SLAVE = 1;
    const int ACTIVE_MASTER_SLAVE = 2;

    // DT modes
    const int DT_DEFAULT = 0;
    const int DT_LP = 1;
    const int DT_HS = 2;

    // MIPI standards
    const int STD_DSI = 0;
    const int STD_CSI = 1;

    // SET_TIMING_MASTER arg1 values
    const int MASTER_LINE_TIME = 0;
    const int MASTER_PIX_CLK = 1;
    const int MASTER_FRAME_RATE = 2;
    const int MASTER_HS_BIT_RATE = 3;

    // SET_3D_PARAMETER arg1 values
    const int PARAM_3D_ENABLE = 0;
    const int PARAM_3D_STREAM_MODE = 1;
    const int PARAM_3D_DISPLAY_ORIENTATION = 2;
    const int PARAM_3D_LR_ORDER = 3;
    const int PARAM_3D_FORMAT = 4;
    const int PARAM_3D_VSYNC = 5;
    const int PARAM_3D_INTER_FRAME_VACT = 6;
    const int PARAM_3D_COUNT = 7;

    // 3D_STREAM_MODE and 3D_DISPLAY_ORIENTATION
    const int PORTRAIT_MODE = 0;
    const int LANDSCAPE_MODE = 1;

    // 3D_LR_ORDER
    const int LEFT_FIRST = 0;
    const int RIGHT_FIRST = 1;

    // 3D_FORMAT
    const int FORMAT_3D_LINE = 0;
    const int FORMAT_3D_FRAME = 1;
    const int FORMAT_3D_PIXEL = 2;

    // options
    const int OPT_LOOP_COMMANDS = 1;
    const int OPT_WAIT_ON_EXT_EVENT_TO_START = 2;
    const int OPT_DISABLE_EVENT_TIMEOUT = 3;
    const int OPT_ENABLE_CMD_INSERTION = 4;
    const int OPT_ENABLE_VIDEO_MODE_IN_MACROS = 5;
    const int OPT_SEND_SINGLE_PKT_PER_HS_BURST = 6;
    const int OPT_CLOCK_ON_WHEN_SENDING_CMDS = 7;
    const int OPT_CLOCK_OFF_AFTER_HS_BURST = 8;
    const int OPT_ENABLE_EOT_PKTS = 9;
    const int OPT_ENCODE_RAW_FORMAT_AS_BAYER = 10;
    const int OPT_ALWAYS_USE_PREDICTOR1_FOR_COMPRESSION = 11;
    const int OPT_ENABLE_WM_PARTITIONING = 12;
    const int OPT_ALLOW_IMAGE_RESCALING = 13;
    const int OPT_WM_QUANTIZE_TO_LINE_LENGTH_MULTIPLE = 14;
    const int OPT_ENABLE_HOLD_TRAIL_TEST_MODE = 15;
    const int OPT_SEND_PPS_WITH_COMPRESSED_VIDEO = 16;
    const int OPT_ENABLE_DSI_SCRAMBLING = 17;

    // DCS Write Memory BMP decode formats
    const int FMT_RGB565_16 = 1;
    const int FMT_RGB666_18 = 2;
    const int FMT_RGB666_24 = 3;
    const int FMT_RGB888_24 = 4;
    const int FMT_YCBCR_420_12 = 11;
    const int FMT_YCBCR_422_16 = 13;
    const int FMT_RGB101010_30 = 23;
    const int FMT_RGB121212_36 = 24;
    const int FMT_YCBCR_422_LOOSE_20 = 25;
    const int FMT_YCBCR_422_24 = 26;
    const int FMT_DSC_COMPRESSED = 33;

    // MIPI standard cmd masks
    const int DSI_CMD_MASK = 0x400;
    const int CSI_CMD_MASK = 0x500;

    // DPhy timing parameters
    const int DPHY_PARAM_HS_PREPARE = 0;
    const int DPHY_PARAM_HS_ZERO = 1;
    const int DPHY_PARAM_HS_TRAIL = 2;
    const int DPHY_PARAM_HS_EXIT = 3;

    const int DPHY_PARAM_CLK_PREPARE = 4;
    const int DPHY_PARAM_CLK_ZERO = 5;
    const int DPHY_PARAM_CLK_TRAIL = 6;
    const int DPHY_PARAM_CLK_PRE = 7;
    const int DPHY_PARAM_CLK_POST = 8;

    const int DPHY_PARAM_TA_GO = 9;
    const int DPHY_PARAM_TA_GET = 10;
    const int DPHY_PARAM_WAKEUP = 11;

    // Blanking modes
    const int AUTO_BLANK_MODE = 0;
    const int LP11_BLANK_MODE = 1;
    const int HS_BLANK_MODE = 2;

    // trigger commands for ASSERT_PROBE_TRIG and FORCE_PROBE_TRIG
    const int TRIG_CMD_LOW = 1;
    const int TRIG_CMD_HIGH = 2;
    const int TRIG_CMD_TOGGLE = 3;
    const int TRIG_CMD_PULSE = 4;


    ////////////////////////////////////////////////////
    // DSI commands 
    // 
    // Note: the command values defined here are applicable when
    // using these command codes in RPC calls via the 
    // PGRemoteRPCClient DLL.  All DSI commands will have 0x400
    // and all CSI commands will have 0x500 added to them
    // (to make them unique across standards).
    ////////////////////////////////////////////////////

    // 0 argument commands
    const int VSYNC_START = 0x401;
    const int VSYNC_END = 0x411;
    const int HSYNC_START = 0x421;
    const int HSYNC_END = 0x431;
    const int EOT_PKT = 0x408;
    const int COLOR_MODE_OFF = 0x402;
    const int COLOR_MODE_ON = 0x412;
    const int SHUT_DOWN_PERIPHERAL = 0x422;
    const int TURN_ON_PERIPHERAL = 0x432;
    const int DCS_READ = 0x406;

    // arg1 = ParamCnt (0, 1, 2)
    // arg2 = Param1[7:0]
    // arg3 = Param2[7:0]
    const int GENERIC_SHORT_WRITE = 0x403;

    // arg1 = ParamCnt (0, 1, 2)
    // arg2 = Param1[7:0]
    // arg3 = Param2[7:0]
	const int GENERIC_READ_REQUEST = 0x404;

    // arg1 = ParamCnt (0, 1)
    // arg2 = Params[7:0]
    // (see DCS short write commands)
    const int DCS_SHORT_WRITE = 0x405;

    // arg1 = MaxReturnPktSize[15:0]
    const int SET_MAX_RETURN_PKT_SIZE = 0x437;

    // arg1 = Mode[15:0]
    const int SCRAMBLING_MODE = 0x427;

    // arg1 = WriteLen
    const int DSI_NULL_PKT = 0x409;

    // arg1 = WriteLen
    const int DSI_BLANKING_PKT = 0x419;

    // option1: non-zero length payload array
    // option2: filename 
    const int GENERIC_LONG_WRITE = 0x429;

    // (see DCS long write commands)
    const int DCS_LONG_WRITE = 0x439;

    // arg1 = FrameCnt
    // arg2 = Interlaced (0 == not interlaced, 1 == interlaced; only applies to YCBCR formats)
    // option1: non-zero length payload array
    // (length = FrameCnt * HTotal * HVTotal * bytesPerPix)
    // option2: filename 
    const int PACKED_PIXEL_STREAM_565 = 0x40e;
    const int PACKED_PIXEL_STREAM_666 = 0x41e;
    const int LOOSE_PIXEL_STREAM_666 = 0x42e;
    const int PACKED_PIXEL_STREAM_888 = 0x43e;
    const int LOOSE_PIXEL_STREAM_20_YCBCR_422 = 0x40c;
    const int PACKED_PIXEL_STREAM_24_YCBCR_422 = 0x41c;
    const int PACKED_PIXEL_STREAM_16_YCBCR_422 = 0x42c;
    const int PACKED_PIXEL_STREAM_101010 = 0x40d;
    const int PACKED_PIXEL_STREAM_121212 = 0x41d;
    const int PACKED_PIXEL_STREAM_12_YCBCR_420 = 0x43d;

    // option1: non-zero length payload array
    // option2: non-empty filename 
    const int COMPRESSED_PIXEL_STREAM = 0x40b;

    // arg1 = Data 0
    // arg2 = Data 1
    const int COMPRESSION_MODE = 0x407;

    // option1: non-zero length payload array
    // option2: non-empty filename 
    const int PICTURE_PARAMETER_SET = 0x40a;

    // No arguments
    const int EXECUTE_QUEUE = 0x416;

    ////////////////////////////////////////////////////
    // CSI commands
    //
    // Note: the command values defined here are applicable when
    // using these command codes in RPC calls via the 
    // PGRemoteRPCClient DLL.  All DSI commands will have 0x400
    // and all CSI commands will have 0x500 added to them
    // (to make them unique across standards).
    ////////////////////////////////////////////////////

    // arg1 = FrameNum[15:0]
    const int FRAME_START = 0x500;
    const int FRAME_END = 0x501;

    // arg1 = LineNum[15:0]
    const int LINE_START = 0x502;
    const int LINE_END = 0x503;

    // arg1 = Value[15:0]
    const int GENERIC_SHORT_PKT1 = 0x508;
    const int GENERIC_SHORT_PKT2 = 0x509;
    const int GENERIC_SHORT_PKT3 = 0x50a;
    const int GENERIC_SHORT_PKT4 = 0x50b;
    const int GENERIC_SHORT_PKT5 = 0x50c;
    const int GENERIC_SHORT_PKT6 = 0x50d;
    const int GENERIC_SHORT_PKT7 = 0x50e;
    const int GENERIC_SHORT_PKT8 = 0x50f;

    // arg1 = WriteLen
    const int CSI_NULL_PKT = 0x510;
    const int CSI_BLANKING_PKT = 0x511;

    // option1: non-zero length payload array
    // option2: filename 
    const int CSI_LONG_PKT = 0x512;

    // arg1 = FrameCnt
    // option1: non-zero length payload array
    // (length = FrameCnt * HTotal * HVTotal * bytesPerPix)
    // option2: filename 
    //
    // A special filename of "USERFRAME<n>" can be used to reference
    // internal frame buffers loaded with the LOAD_FRAME command, where
    // <n> is 0 to 3.  When "USERFRAME<n>" is used as the filename,
    // arg1 = byte offset in frame buffer
    // arg2 = byte length of packet
    const int PIXEL_STREAM_YUV420L_8 = 0x51A;
    const int PIXEL_STREAM_YUV422_8 = 0x51E;
    const int PIXEL_STREAM_YUV422_10 = 0x51F;
    const int PIXEL_STREAM_RGB444 = 0x520;
    const int PIXEL_STREAM_RGB555 = 0x521;
    const int PIXEL_STREAM_RGB565 = 0x522;
    const int PIXEL_STREAM_RGB666 = 0x523;
    const int PIXEL_STREAM_RGB888 = 0x524;
    const int PIXEL_STREAM_RAW6 = 0x528;
    const int PIXEL_STREAM_RAW7 = 0x529;
    const int PIXEL_STREAM_RAW8 = 0x52A;
    const int PIXEL_STREAM_RAW10 = 0x52B;
    const int PIXEL_STREAM_RAW12 = 0x52C;
    const int PIXEL_STREAM_RAW14 = 0x52D;

    // option1: non-zero length payload array
    // option2: filename 
    const int USER_8BIT_TYPE1 = 0x530;
    const int USER_8BIT_TYPE2 = 0x531;
    const int USER_8BIT_TYPE3 = 0x532;
    const int USER_8BIT_TYPE4 = 0x533;
    const int USER_8BIT_TYPE5 = 0x534;
    const int USER_8BIT_TYPE6 = 0x535;
    const int USER_8BIT_TYPE7 = 0x536;
    const int USER_8BIT_TYPE8 = 0x537;

    // arg1 = FrameCnt
    // arg2 = User DataType
    // option1: non-zero length payload array
    // option2: filename 
    const int RAW_COMPRESSED_10_8_10 = 0x5f4;
    const int RAW_COMPRESSED_10_7_10 = 0x5f5;
    const int RAW_COMPRESSED_10_6_10 = 0x5f6;
    const int RAW_COMPRESSED_12_8_12 = 0x5f7;
    const int RAW_COMPRESSED_12_7_12 = 0x5f8;
    const int RAW_COMPRESSED_12_6_12 = 0x5f9;

    ////////////////////////////////////////////////////
    // DPHY and generic commands
    // NOTE: these correspond to NON_PKT_TYPE defines in DSIToPG class + 0x100
    ////////////////////////////////////////////////////
    // no arguments
    const int SEND_BTA = 0x102;
    const int RESET_TRIGGER = 0x104;
    const int TRIGGER1 = 0x105;
    const int TRIGGER2 = 0x106;
    const int TRIGGER3 = 0x107;

    // arg1 = CmdByte[7:0]
    const int ESCAPE = 0x108;

    // arg1 = delay in ns
    // arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    const int LP_DELAY = 0x109;

    // arg1 = LaneMask[4:0]
    const int ULPS = 0x10a;

    // no arguments
    const int WAIT_FOR_BTA = 0x10c;
    const int CLOCK_ON = 0x10d;
    const int CLOCK_OFF = 0x10e;

    // waits for input event
    // arg1 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    const int WAIT_EXT_EVENT = 0x110;

    // Defines a command insertion point when used in looping macro
    // arg1 = delay in ns
    // arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    // arg3 = discard flag (0 == suspend program while inserting; 1 == discard input while inserting)
    const int CMD_INSERTION_POINT = 0x112;

    // Asserts TrigOut on the instrument 
    // NOTE: this is for probe trigger control during the command 
    // (use FORCE_TRIG command to affect TrigOut immediately)
    // arg1 = delay in ns
    // arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    // arg3 = trigger command: 0 (low voltage), 1 (high voltage), 2 (toggle voltage), 3 (pulse voltage)
    // Note: Toggle command starts from current voltage (i.e. may be low->high or high->low)
    // Note: Pulse command starts from current voltage (i.e. may be low->high->low or high->low->high)
    // Use SET_TRIG_DURATION command to set the pulse width
    const int ASSERT_TRIG = 0x113;

    // Asserts LP state (and possibly HS clock state) onto the bus until the specified position
    // in the current macro.  The delay parameter is interpreted relative to the "zero position"
    // as indicated by the last call (in the macro) of MARK_ZERO_POS.  If there is no last
    // call to MARK_ZERO_POS, the start of the macro is used.  
    //
    // arg1 = delay in ns
    // arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    const int LP_DELAY_TO_POS = 0x114;

    // no arguments
    // Records the current position when compiling a macro to use as a time reference
    // (Subsequent calls to LP_DELAY_TO_POS use this "zero position" as the reference
    // to allow exact timing for constructing video lines).
    const int MARK_ZERO_POS = 0x115;

    // arg1 = seed (int, applies to all lanes)
    // arg2 = WordCnt (int)
    const int PRBS9_SEQ = 0x116;
    const int PRBS11_SEQ = 0x117;
    const int PRBS18_SEQ = 0x118;

    // arg1 = LoopCnt (int)
    // Params[] contained in non-zero length payload array
    const int TGR_DATA_SEQ = 0x119;
    const int TGR_BIT_SEQ = 0x11a;

    // non-null filename 
    const int FILE_COMMAND = 0x11c;

    // arg1 = duration (UI, int)
    const int SKEW_CALIBRATION = 0x11d;

    // Same as LP_DELAY with UI units
    // arg1 = duration (UI, int)
    // arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    const int LP_DELAY_UI = 0x11e;

    // Same as LP_DELAY_TO_POS with UI units
    // arg1 = duration (UI, int)
    // arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    const int LP_DELAY_TO_POS_UI = 0x11f;

    // arg1 = loop iterations
    const int LOOP_START = 0x120;

    // no arguments
    const int LOOP_END = 0x121;

    // no arguments; provide non-null filename
    const int PG_FILE = 0x122;

    // arg1 = ParamCnt (1, 2)
    // arg2 = Parameter byte 1 
    // arg3 = Parameter byte 2 (if necessary)
    const int GENERIC_SHORT_READ_RESPONSE = 0x1f5;

    // option1: non-zero length payload array
    // option2: filename 
    const int GENERIC_LONG_READ_RESPONSE = 0x1f6;

    // arg1 = ParamCnt (1, 2)
    // arg2 = Parameter byte 1 
    // arg3 = Parameter byte 2 (if necessary)
    const int DCS_SHORT_READ_RESPONSE = 0x1f7;

    // option1: non-zero length payload array
    // option2: filename 
    const int DCS_LONG_READ_RESPONSE = 0x1f8;

    // arg1 = ErrorBits[15:0]
    const int ACK_AND_ERROR_REPORT = 0x1f9;

    // arg1 = DataID
    // data block with command data
    const int CUSTOM_LONG_COMMAND = 0x1fa;

    // arg1 = DataID
    // data block with command data
    const int CUSTOM_COMMAND = 0x1fc;

    // arg1: filename
    const int RPC_SCRIPT = 0x1fd;

    ////////////////////////////////////////////////
    // DCS_SHORT_WRITE cmd types
    ////////////////////////////////////////////////

    // 0 argument commands
    const int ENTER_IDLE_MODE = 0x39;
    const int ENTER_INVERT_MODE = 0x21;
    const int ENTER_NORMAL_MODE = 0x13;
    const int ENTER_PARTIAL_MODE = 0x12;
    const int ENTER_SLEEP_MODE = 0x10;
    const int EXIT_IDLE_MODE = 0x38;
    const int EXIT_INVERT_MODE = 0x20;
    const int EXIT_SLEEP_MODE = 0x11;
    const int NOP = 0;
    const int SET_DISPLAY_OFF = 0x28;
    const int SET_DISPLAY_ON = 0x29;
    const int SET_TEAR_OFF = 0x34;
    const int SOFT_RESET = 0x01;

    // arg1 = Mode[7:0]
    const int SET_ADDRESS_MODE = 0x36;

    // arg1 = Mode[7:0]
    const int SET_3D_CONTROL = 0x3d;

    // arg1 = GammaCurve[7:0]
    const int SET_GAMMA_CURVE = 0x26;

    // arg1 = Format[7:0]
    const int SET_PIXEL_FORMAT = 0x3a;

    // arg1 = M[0]
    const int SET_TEAR_ON = 0x35;

    // arg1 = Timing[7:0]
    const int SET_VSYNC_TIMING = 0x40;

    // arg1 = Ctl[7:0]
    const int WRITE_CONTROL_DISPLAY = 0x53;

    // arg1 = PS[7:0]
    const int WRITE_POWER_SAVE = 0x55;

    ////////////////////////////////////////////////
    // DCS_READ cmd types
    ////////////////////////////////////////////////

    const int GET_ADDRESS_MODE = 0x0b;
    const int GET_3D_CONTROL = 0x3f;
    const int GET_COMPRESSION_MODE = 0x03;
    const int GET_BLUE_CHANNEL = 0x08;
    const int GET_DIAGNOSTIC_RESULT = 0x0f;
    const int GET_DISPLAY_MODE = 0x0d;
    const int GET_GREEN_CHANNEL = 0x07;
    const int GET_PIXEL_FORMAT = 0x0c;
    const int GET_POWER_MODE = 0x0a;
    const int GET_RED_CHANNEL = 0x06;
    const int GET_SCANLINE = 0x45;
    const int GET_SIGNAL_MODE = 0x0e;
    const int READ_DDB_CONTINUE = 0xa8;
    const int READ_DDB_START = 0xa1;
    const int READ_MEMORY_CONTINUE = 0x3e;
    const int READ_MEMORY_START = 0x2e;
    const int READ_PPS_CONTINUE = 0xa9;
    const int READ_PPS_START = 0xa2;

    const int GET_CABC_MIN_BRIGHTNESS = 0x5f;
    const int GET_CONTROL_DISPLAY = 0x54;
    const int GET_DISPLAY_BRIGHTNESS = 0x52;
    const int GET_ERROR_COUNT_ON_DSI = 0x05;
    const int GET_IMAGE_CHECKSUM_CT = 0x15;
    const int GET_IMAGE_CHECKSUM_RGB = 0x14;
    const int GET_POWER_SAVE = 0x56;

    ////////////////////////////////////////////////
    // DCS_LONG_WRITE cmd types
    ////////////////////////////////////////////////

    // arg1 = VertScrollPtr[15:0]
    const int SET_SCROLL_START = 0x37;

    // arg1 = Line[15:0]
    const int SET_TEAR_SCANLINE = 0x44;

    // arg1 = StartColumn[15:0]
    // arg2 = EndColumn[15:0]
    const int SET_COLUMN_ADDRESS = 0x2a;

    // arg1 = StartPage[15:0]
    // arg2 = EndPage[15:0]
    const int SET_PAGE_ADDRESS = 0x2b;

    // arg1 = StartRow[15:0]
    // arg2 = EndRow[15:0]
    const int SET_PARTIAL_ROWS = 0x30;

    // arg1 = StartCol[15:0]
    // arg2 = EndCol[15:0]
    const int SET_PARTIAL_COLUMNS = 0x31;

    // arg1 = TopFixedArea[15:0];
    // arg2 = VertScrollArea[15:0];
    // arg3 = BotFixedArea[15:0];
    const int SET_SCROLL_AREA = 0x33;

    // arg1 = Brightness[15:0]
    const int SET_CABC_MIN_BRIGHTNESS = 0x5e;

    // arg1 = Brightness[15:0]
    const int SET_DISPLAY_BRIGHTNESS = 0x51;

    // option1: non-zero length payload array
    // option2: filename 
    const int WRITE_LUT = 0x2d;

    // arg1 = FileOffset
    // arg2 = WriteLen
    // option1: non-zero length payload array
    //          (FileOffset and WriteLen are ignored)
    // option2: filename 
    const int WRITE_MEMORY_CONTINUE = 0x3c;

    // arg1 = FileOffset
    // arg2 = WriteLen
    // option1: non-zero length payload array
    //          (FileOffset and WriteLen are ignored)
    // option2: filename 
    const int WRITE_MEMORY_START = 0x2c;
};

extern FuncNewClient NewClient;
extern FuncConnect Connect;
extern FuncGetS GetLastErrMsg;
extern FuncGetS GetLastStatusMsg;
extern FuncFree Free;
extern FuncRPCCmd RPCCmd;
extern FuncRPCCmdI RPCCmdI;
extern FuncRPCCmdF RPCCmdF;
extern FuncRPCCmdS RPCCmdS;
extern FuncRPCCmdII RPCCmdII;
extern FuncRPCCmdIF RPCCmdIF;
extern FuncRPCCmdIS RPCCmdIS;
extern FuncRPCCmdIII RPCCmdIII;
extern FuncRPCCmdIIS RPCCmdIIS;
extern FuncRPCCmdSIS RPCCmdSIS;
extern FuncRPCCmdIIBA RPCCmdIIBA;
extern FuncRPCCmdIISS RPCCmdIISS;
extern FuncRPCCmdSISI RPCCmdSISI;
extern FuncRPCQueryIRetS RPCQueryIRetS;
extern FuncRPCQuerySRetS RPCQuerySRetS;
extern FuncRPCQueryRetBA RPCQueryRetBA;
extern FuncRPCQueryRetIA RPCQueryRetIA;
extern FuncMIPICmd MIPICmd;

extern RPCErrsClass RPCErrs;
extern RPCCmdsClass RPCCmds;
extern RPCDefsClass RPCDefs;

void InitDLL();

#endif




