class RPCErrs:
    FAIL = -1
    UNKNOWN_CMD = -3
    NOT_LICENSED = -6
    ARGTYPE_MISMATCH = -7

    USB_OPEN_FAILED = -100
    DEVICE_NOT_PRESENT = -101
    USB_TIMEOUT = -102
    MAX_LEN_EXCEEDED = -103
    CANT_OPEN_FILE = -104
    FILE_DOESNT_EXIST = -105
    FILE_TOO_SHORT = -106
    IO_ERROR = -107
    INVALID_PARAM = -108
    BAD_RBF_FILE_LEN = -109
    BAD_MAGIC_NUMBER = -110
    DDRBW_FIFO_OVERFLOW = -111
    DDRBW_DID_NOT_COMPLETE = -112
    VERIFY_FAILED = -113
    ABORT = -114
    TIMEOUT = -115
    CANT_ACQUIRE_SEMA = -116
    NO_PROGSTATE_DEFINED = -117
    BAD_SERIAL_NUMBER = -118
    BAD_FIRMWARE_FILE_LEN = -119
    BAD_SECURITY_FILE = -120
    INVALID_FIRMWARE_FILE = -121
    FLASH_VERIFY_ERROR = -122
    CAPT_STATE_MISMATCH = -123
    NO_CONNECTION = -124
    REMOTE_PG_CALL_FAILED = -125
    BAD_FRAME_PARAMETERS = -126
    BAD_LINE_TIME = -127
    INVALID_SYNC_LINE_CNT = -128
    INVALID_ACTIVE_PIX_CNT = -129
    INVALID_HEIGHT_OR_WIDTH = -130
    CANT_CONFIGURE_P375 = -131
    PG_IS_RUNNING = -132
    INSUFFICIENT_PG_MEMORY = -133
    THREAD_IS_BUSY = -134
    INVALID_TIMING_PARAM = -136
    INVALID_HSYNC_PARAM = -137
    INVALID_HFRONTPORCH_PARAM = -138
    INVALID_HBACKPORCH_PARAM = -139
    AGGREGATE_HS_PKT_LANE_MISMATCH = -140
    NO_BLANKING_ADJ = -141
    HSA_TOO_SHORT = -142
    HBP_TOO_SHORT = -143
    HFP_TOO_SHORT = -144
    MAX_PAYLOAD_EXCEEDED = -145
    TEST_DID_NOT_COMPLETE = -146
    SESSION_EXPIRED = -148
    INVALID_VBACKPORCH_PARAM = -152
    BAD_HS_MODE = -153
    BAD_LP_REPL = -154
    SEG_UNALIGNED = -155
    INSERTION_CODE_NOT_FOUND = -161
    INSERTION_CMD_TOO_LONG = -162
    BTA_TIMEOUT = -163
    CANT_LOCK_HS_PLL = -166
    INVALID_HS_BITRATE = -169
    CANT_RESTART = -170
    PARSE_ERR = -172
    UNKNOWN_MIPI_CMD = -173
    NEED_START_EDIT_CMD = -174
    CONTROL_IS_DISABLED = -175
    UNEXPECTED_ARG_TYPE = -176
    PAYLOAD_TOO_SHORT = -177
    CMD_STANDARD_MISMATCH = -178
    UNKNOWN_DCS_CMD = -180
    CANT_PARTITION_FILE_CMD = -181
    LP_DELAY_TOO_LONG = -182
    INSERTION_BLOCK_TOO_LONG = -183
    TOO_FEW_TOKENS = -191
    VALUE_OUT_OF_RANGE = -192
    OBJECT_NOT_FOUND = -193
    USER_CANCELED = -194
    BLANKING_SEGMENT_TOO_SHORT = -199
    BLANKING_SEGMENT_TOO_LONG = -205
    INVALID_VACTIVE_PARAM = -206
    INVALID_VFRONTPORCH_PARAM = -207
    UNEXPECTED_PG_COUNT = -208

    PORT_IS_UNAVAILABLE = -300
    CANT_PARSE_VALUE = -305
    NOT_BINARY_GEN_FILE = -310
    INVALID_EEPROM_VALUE = -311
    SILENT_ERROR = -999

    LOCAL_FAILURE = -5000

class RPCCmds:
    ##########################
    # command management
    ##########################

    SEND_MIPI_CMD = 1

    # Create a named command in the application
    # (Will delete an existing command by the same name if it exists)
    # (If sent while defining macro, only names the component 
    # command being added to macro)
    # Uses same arguments as SEND_MIPI_CMD with one additional argument (first argument)
    # First argument: command name (string)
    ADD_MIPI_CMD = 2

    SEND_IMPAIRED_MIPI_CMD = 4

    # arg1: Cmd name (string)
    # sends the (already defined) named command given its Cmd name, as if sent from the GUI
    SEND_NAMED_CMD_FROM_NAME = 5

    # arg1: Cmd index (integer)
    # sends the (already defined) named command given its Cmd index, as if sent from the GUI
    SEND_NAMED_CMD_FROM_INDEX = 6

    # Deletes a named command in the application
    # arg1: command name (string)
    DELETE_NAMED_CMD = 7

    # Deletes all named commands in the application
    # no arguments
    DELETE_ALL_NAMED_CMDS = 8

    # arg1 = 0 (disable), 1 (enable)
    SET_SORT_CMDS = 9

    # no arguments, returns number of named Cmds defined (integer)
    GET_NAMED_CMD_COUNT = 10

    # arg1: Cmd index (integer)
    # returns the Cmd name associated with the given Cmd index (string)
    GET_NAMED_CMD_NAME = 11

    # arg1: command name (string)
    # selects the named command in the GUI Cmd list
    SELECT_NAMED_CMD = 12

    # Uses same arguments as SEND_IMPAIRED_MIPI_CMD with one additional argument (first argument)
    # First argument: command name (string)
    ADD_IMPAIRED_MIPI_CMD = 13

    ##########################
    # instrument configuration commands
    ##########################

    # arg1 = mode (DT_HS, DT_LP, DT_DEFAULT)
    SET_DT_MODE = 0x101

    # arg1 = LP_FREQ (float, Hz, 0.2 - 30 MHz)
    SET_LP_FREQ = 0x102

    # arg1 = HS_BIT_RATE (float, sym/sec, 23.44 to 6000 Msps)
    SET_HS_BIT_RATE = 0x103

    # arg1 = lane count (int, 1-4)
    SET_LANE_CNT = 0x104

    # arg1 = 0 (disable), 1 (enable)
    SET_FORCE_TEST_PATTERN = 0x105

    # arg1 = 0 (disable), 1 (enable)
    SET_ALL_HS_VOLT_COMMON = 0x106

    # arg1 = channel (int, 0-4, clk == 4)
    # arg2 = voltage (float, volts, -0.6 to 1.2 V)
    SET_HS_LOW_VOLT = 0x107
    SET_HS_HIGH_VOLT = 0x108

    # arg1 = voltage (float, volts, -0.28 to 1.8 V)
    SET_LP_LOW_VOLT = 0x109
    SET_LP_HIGH_VOLT = 0x10a

    # arg1 = lane (int, 0-4, clk == 4)
    # arg2 = delay (float, sec)
    SET_LANE_DELAY = 0x10b

    # arg1 = 0 (disable), 1 (enable)
    SET_AUTO_SET_CLOCK_DELAY = 0x10c

    # arg1 = voltage (float, volts, 0.0 to 1.0 V)
    SET_LP_LOW_CONT_THRESH = 0x10d
    SET_LP_HIGH_CONT_THRESH = 0x10e

    # arg1 = time (float, sec, 0.1 to 100 ms)
    SET_BTA_WAIT_TIME = 0x10f

    # arg1 = time (float, sec, 0.1 us to 100 ms)
    SET_TRIG_PULSE_WIDTH = 0x110

    # arg1 = lane map 
    # laneMap[3..0] represents the source lane to use for phy lane 0
    # laneMap[7..4] represents the source lane to use for phy lane 1
    # laneMap[11..8] represents the source lane to use for phy lane 2
    # laneMap[15..12] represents the source lane to use for phy lane 3
    # laneMap[19..16] represents the source lane to use for the clock lane
    # Use lane = 4 for clock lane
    # Example, unity mapping is: 43210h
    SET_LANE_MAP = 0x111

    # arg1 = 0 == master 1 == slave 2 == master/slave
    SET_ACTIVE_LINKS = 0x113

    # arg1 = 0 == disable, 1 == enable
    SET_LINK_TO_SLAVE = 0x114

    # arg = preemphasis (int, 0-4095)
    SET_PREEMPHASIS = 0x115

    # no arguments								 
    # bracket any instrument configuration calls with START_EDIT_CONFIG/END_EDIT_CONFIG
    START_EDIT_CONFIG = 0x160

    # no arguments
    # initializes instrument with new configuration settings
    END_EDIT_CONFIG = 0x161


    ##########################
    # timing configuration commands
    ##########################

    # arg1 = UI (int)
    SET_TIMING_SKEW_CAL_UI = 0x17e

    # arg1 = 0 (disable), 1 (enable)
    SET_TIMING_ENABLE_SKEW_CAL = 0x17f

    # arg1 = pixel count (int)
    SET_TIMING_HSYNC = 0x181
    SET_TIMING_HBPORCH = 0x182
    SET_TIMING_HFPORCH = 0x183
    SET_TIMING_HACTIVE = 0x184

    # arg1 = line count (int)
    SET_TIMING_VSYNC = 0x185
    SET_TIMING_VBPORCH = 0x186
    SET_TIMING_VFPORCH = 0x187
    SET_TIMING_VACTIVE = 0x188

    # arg1 = line time (float, sec)
    SET_TIMING_LINE_TIME = 0x189

    # arg1 = pixel clock frequency (float, Hz)
    SET_TIMING_PIX_CLK = 0x18a

    # arg1 = frame rate (float, Hz)
    SET_TIMING_FRAME_RATE = 0x18b

    # arg1 = HS Bit Rate (float, Hz)
    SET_TIMING_HS_BIT_RATE = 0x19b

    # arg1 = 0 (disable), 1 (enable)
    SET_TIMING_ENABLE_DSI_PULSE_MODE = 0x18c
    SET_TIMING_ENABLE_DSI_BURST_MODE = 0x18d
    SET_TIMING_ENABLE_CSI_LSLE_MODE = 0x18e
    SET_TIMING_ENABLE_CSI_FRAME_NUMBERING = 0x18f
    SET_TIMING_ENABLE_CSI_LINE_NUMBERING = 0x190

    # arg1 = blanking mode (AUTO_BLANK_MODE, HS_BLANK_MODE, LP11_BLANK_MODE)
    SET_TIMING_HSYNC_BLANKING_MODE = 0x191
    SET_TIMING_HBPORCH_BLANKING_MODE = 0x192
    SET_TIMING_HFPORCH_BLANKING_MODE = 0x193
    SET_TIMING_VERTICAL_BLANKING_MODE = 0x194

    # arg1 = 0 (disable), 1 (enable)
    SET_TIMING_TOP_FIELD_FIRST = 0x195

    # arg1 = 0 (disable), 1 (enable)
    SET_TIMING_CLK_ON_OFF_DURING_LP11_BLANKING = 0x19c

    # arg1 = 3D parameter number (int, PARAM_3D_x defines)
    # arg2 = 3D parameter value (int)
    SET_3D_PARAMETER = 0x19d

    # arg1 = timing master (int, MASTER_x defines)
    SET_TIMING_MASTER = 0x19e

    # arg1 = 0 (disable), 1 (enable)
    SET_ADVANCE_FRAME_ON_EXTERNAL_EVENT = 0x19f

    # arg1 = timing configuration name (string)
    SELECT_TIMING_CONFIG = 0x196

    # arg1 = timing configuration name (string)
    SAVE_TIMING_CONFIG = 0x197

    # arg1 = timing configuration name (string)
    DELETE_TIMING_CONFIG = 0x198

    # no arguments
    DELETE_ALL_TIMING_CONFIGS = 0x199

    # arg1 = 0 (disable), 1 (enable)
    SET_SORT_TIMING_CONFIGS = 0x19a

    # used: 0x19b, 0x19c, 0x19d, 0x19e, 0x19f

    # arg1 = 0 (disable), 1 (enable)
    SET_TIMING_ENABLE_CONTINUOUS_MODE = 0x1d0

    # arg1 = DSC configuration name (string)
    SELECT_DSC_CONFIG = 0x1a0

    # arg1 = DSC configuration name (string)
    SAVE_DSC_CONFIG = 0x1a1

    # arg1 = DSC configuration name (string)
    DELETE_DSC_CONFIG = 0x1a2

    # no arguments
    DELETE_ALL_DSC_CONFIGS = 0x1a3

    # arg1 = 0 (disable), 1 (enable)
    SET_SORT_DSC_CONFIGS = 0x1a4

    # arg1 = field value (int)
    SET_DSC_SLICE_WIDTH = 0x1a5
    SET_DSC_SLICE_HEIGHT = 0x1a6
    SET_DSC_ENABLE_422 = 0x1a7
    SET_DSC_USE_YUV_INPUT = 0x1a8
    SET_DSC_USE_BLOCK_PREDICTION = 0x1a9
    SET_DSC_ONE_CHUNK_PER_PACKET = 0x1aa

    # arg1 = configuration filename (string)
    SET_DSC_CONFIG_FILENAME = 0x1ab

    # arg1 = source filename (string)
    # arg2 = DSC filename (string)
    DSC_COMPRESS_FILE = 0x1ac

    # arg1 = DSC filename (string)
    # arg2 = source filename (string)
    DSC_UNCOMPRESS_FILE = 0x1ad

    # arg1 = DUAL_IF_x defines
    SET_DUAL_INTERFACE_MODE = 0x1ae

    # arg1 = field value (int, 0 = false, 1 == true)
    # (SET_DSC_ENABLE_SIMPLE_422 is alias for SET_DSC_ENABLE_422 
    # which is deprecated for DSC 1.2)
    SET_DSC_ENABLE_SIMPLE_422 = 0x1a7
    SET_DSC_ENABLE_NATIVE_422 = 0x1af
    SET_DSC_ENABLE_NATIVE_420 = 0x1f0
    SET_DSC_USE_REC_709 = 0x1f1
    SET_DSC_VERSION_12 = 0x1f2

    ##########################
    # DPhy Timing configuration commands
    ##########################

    # arg1 = parameter (DPHY_PARAM_* definition)
    # arg2 = nsValue (int)
    # arg3 = UIValue (int)
    # arg4 = TLPXValue (int)
    SET_DPHY_PARAMETER = 0x201

    # arg1 = DPhy configuration name (string)
    SELECT_DPHY_CONFIG = 0x207

    # arg1 = DPhy configuration name (string)
    SAVE_DPHY_CONFIG = 0x208

    # arg1 = DPhy configuration name (string)
    DELETE_DPHY_CONFIG = 0x209

    # no arguments
    DELETE_ALL_DPHY_CONFIGS = 0x20a

    # arg1 = 0 (disable), 1 (enable)
    SET_SORT_DPHY_CONFIGS = 0x20b

    ##########################
    # macro defintion
    ##########################

    # no arguments puts PGRemote in macro mode (discarding previous macro)
    # any (non-video) MIPI_CMDs sent will append to current macro
    START_MACRO = 0x280

    # Create a named macro in the application
    # (Deletes an existing macro by the same name if it exists)
    # arg1: macro name (string)
    END_MACRO = 0x281

    # Ends and sends the current macro (must still be in macro_mode).  Macro is discarded.
    SEND_MACRO = 0x282

    # Measures the current macro (must still be in macro_mode).  Macro is discarded
    MEASURE_MACRO = 0x283

    # arg1: zero-based component command index (int)
	# arg2: component command name (string)
    RENAME_MACRO_COMPONENT_COMMAND = 0x284

    ##########################
    # status commands
    ##########################

    # no arguments returns 0 (not connected), 1 (connected), <0 (error)
    IS_INST_CONNECTED = 0x300

    # no arguments returns 0 (not running), 1 (running), <0 (error)
    IS_PROGRAM_RUNNING = 0x301

    # no arguments returns contention mask, <0 (error)
    # mask consists of six bits {CTN_LP0L, CTN_LP1L, CTN_LP0H, CTN_LP1H}
    GET_LP_CONTENTION = 0x302

    # no arguments
    RESET_LP_CONTENTION = 0x303

    # no arguments
    # returns integer array of captured data
    # Flags in data: 0x100 = START_BURST, 0x200 = END_BURST
    # START_BURST data contains first 2 escape entry bits (should always be b"01")
    # END_BURST data contains partial byte bits followed by return BTA (should always be b"11")
    # END_BURST data also contains # of valid bits - 1 in D[12..10]
    GET_DUT_RESPONSE = 0x304

    # arg1 = fileName: name of file to save DUT response data as text data
    # arg2 = appendFlag (integer): set to non-zero to append to file
    # arg3 = commentString: comment to save with response set to "" for no comment
    SAVE_DUT_RESPONSE = 0x305

    # no arguments, returns inputState[1..0] (integer)
    GET_INST_GP_INPUT_STATE = 0x306

    # arg1: fileName: name of file to save PG event state as integer value
    # arg2: appendFlag (integer): set to non-zero to append to file
    # arg3: commentString: comment to save with response set to "" for no comment        
    SAVE_INST_GP_INPUT_STATE = 0x307

    ##########################
    # frame buffer commands
    ##########################

    # arg1: buffer number, (integer, 0-3)
    # arg2: dataType specifying video format that will be used with this frame (integer)
    # arg3: file name (string)
    # Loads the frame from the given file, converts to the given video format, and stores
    #  into the given frame buffer number (use DEALLOC_FRAME to deallocate when done)
    LOAD_FRAME = 0x380

    # arg1: buffer number, (integer, 0-3)
    # Deallocates the frame stored in the given frame buffer
    DEALLOC_FRAME = 0x381

    ##########################
    # WriteMemory configuration commands
    ##########################

    # arg1 = maximum number of bytes per DCS WriteMemory partition
    SET_WM_PARTITION_LENGTH = 0x3a0

    # arg1 = LP11 time between DCS WriteMemory partitions (float, sec)
    SET_WM_PARTITION_INTERVAL = 0x3a1

    # arg1 = DCS WriteMemory BMP decode format (FMT_xxx)
    SET_WM_IMAGE_DECODE_FORMAT = 0x3a2

    # arg1 = DCS WriteMemory RGB bit order (WM_BIT_ORDER_xxx)
    SET_WM_RGB_BIT_ORDER = 0x3a3

    ##########################
    # RPC commands
    ##########################

    # arg1: Cmd name (string)
    # returns the RPC string associated with the given Cmd name (string)
    GET_RPC_CMD_STRING_FROM_NAME = 0x400

    # arg1: Cmd index (integer)
    # returns the RPC string associated with the given Cmd index (string)
    GET_RPC_CMD_STRING_FROM_INDEX = 0x401

    # arg1: RPC command string (string)
    # executes the given RPC command string
    # the string may have multiple RPC commands separated by <CR><LF> or <CR>
    # (all rules of RPC script files can be followed)
    EXECUTE_RPC_CMD_STRING = 0x402

    ##########################
    # options
    ##########################

    # arg1 = option (OPT_XXX defines)
    # arg2 = 0 (disable), 1 (enable)
    SET_OPTION = 0x480

    # arg1 = standard (STD_DSI, STD_CSI)
    SET_MIPI_STANDARD = 0x481

    # Sets the Bayer encode type for CSI RAW images (when Bayer encoding is enabled)
    # arg1: string representing bayer format 
    # ("GRBG", "RGGB", "BGGR", "GBRG")
    SET_BAYER_ENCODE_TYPE = 0x482

    # arg1 = option (OPT_XXX defines)
    # returns the option setting: 0 (disabled), 1 (enabled)
    GET_OPTION = 0x483

    # arg1 = loop count (integer, 0 for infinite)
    # note: does not automatically enable looping
    # (use OPT_LOOP_COMMANDS to enable looping)
    SET_LOOP_COUNT = 0x484

    ##########################
    # other commands
    ##########################

    # arg1 = hostname (string)
    INST_CONNECT = 0x500

    # no arguments
    INST_DISCONNECT = 0x501


    # arg1 = user message string enclosed in double-quotes 
    # displays message box to user with OK button (no timeout)
    USER_WAIT = 0x502

    # no arguments
    STOP_PG = 0x503
    RESTART_PG = 0x504

    # Loads the button and command configuration from the given configuration file.
    # arg1: configuration file name (string)
    LOAD_CONFIG = 0x505

    # Saves the current button and command configuration to the given configuration file.
    # arg1: configuration file name (string)
    SAVE_CONFIG = 0x506

    # Assigns command to a button in the application
    # (Will replace an existing button assignment, use "" to unassign)
    # (use button page = -1 for all pages, e.g. for group unassignment)
    # (use button number = -1 for all buttons on page, e.g. for group unassignment)
    # arg1: button page (0-3, int)
    # arg2: button number in page (0-29, int)
    # arg3: command name (string)
    # arg4: tooltip (string)
    ASSIGN_BUTTON = 0x507

    # Writes current state as a RPC commands to the given script filename
    # (overwrites existing file)
    # arg1: script file name (string)
    WRITE_CURRENT_STATE = 0x508

    # Asserts TrigOut on instrument
    # 
    # NOTE: this is for immediate probe trigger control
    # (use ASSERT_TRIG command to set TrigOut from MIPI stream)
    # arg1 = trigger command: 0 (low), 1 (high), 
    #                         2 (toggle), 3 (pulse)
    # Use SET_TRIG_PULSE_WIDTH to set the pulse width
    FORCE_TRIG = 0x509

    COMPUTE_CRC = 0x50a
    COMPUTE_ECC = 0x50b

    # arg1: local/master (0), slave (1)
    SET_RPC_TARGET = 0x50c

    # arg1: RPC port number (int), set to zero to un-sync
    # arg2: slave instrument serial number (0 for offline)
    SYNC_WITH_SLAVE = 0x50d

    # arg1: 0 == hide, 1 == show
    SHOW_SLAVE_GUI = 0x50e

    # arg1 == 0 = hide, 1 == show 
    SHOW_GUI = 0x50f

class RPCDefs:
    # WriteMemory RGB Bit Order
    WM_BIT_ORDER_LEGACY = 0
    WM_BIT_ORDER_DCS_ANNEX_A = 1

    # Dual-interface image modes
    DUAL_IF_MODE_CLONE_IMAGE = 0
    DUAL_IF_MODE_DUAL_IMAGE = 1
    DUAL_IF_MODE_LEFT_RIGHT_IMAGE = 2
    DUAL_IF_MODE_EVEN_ODD_PIXEL = 3

    # Active Links
    ACTIVE_MASTER = 0
    ACTIVE_SLAVE = 1
    ACTIVE_MASTER_SLAVE = 2

    # DT modes
    DT_DEFAULT = 0
    DT_LP = 1
    DT_HS = 2

    # MIPI standards
    STD_DSI = 0
    STD_CSI = 1

    # SET_TIMING_MASTER arg1 values
    MASTER_LINE_TIME = 0
    MASTER_PIX_CLK = 1
    MASTER_FRAME_RATE = 2
    MASTER_HS_BIT_RATE = 3

    # SET_3D_PARAMETER arg1 values
    PARAM_3D_ENABLE = 0
    PARAM_3D_STREAM_MODE = 1
    PARAM_3D_DISPLAY_ORIENTATION = 2
    PARAM_3D_LR_ORDER = 3
    PARAM_3D_FORMAT = 4
    PARAM_3D_VSYNC = 5
    PARAM_3D_INTER_FRAME_VACT = 6
    PARAM_3D_COUNT = 7

    # 3D_STREAM_MODE and 3D_DISPLAY_ORIENTATION
    PORTRAIT_MODE = 0
    LANDSCAPE_MODE = 1

    # 3D_LR_ORDER
    LEFT_FIRST = 0
    RIGHT_FIRST = 1

    # 3D_FORMAT
    FORMAT_3D_LINE = 0
    FORMAT_3D_FRAME = 1
    FORMAT_3D_PIXEL = 2

    # options
    OPT_LOOP_COMMANDS = 1
    OPT_WAIT_ON_EXT_EVENT_TO_START = 2
    OPT_DISABLE_EVENT_TIMEOUT = 3
    OPT_ENABLE_CMD_INSERTION = 4
    OPT_ENABLE_VIDEO_MODE_IN_MACROS = 5
    OPT_SEND_SINGLE_PKT_PER_HS_BURST = 6
    OPT_CLOCK_ON_WHEN_SENDING_CMDS = 7
    OPT_CLOCK_OFF_AFTER_HS_BURST = 8
    OPT_ENABLE_EOT_PKTS = 9
    OPT_ENCODE_RAW_FORMAT_AS_BAYER = 10
    OPT_ALWAYS_USE_PREDICTOR1_FOR_COMPRESSION = 11
    OPT_ENABLE_WM_PARTITIONING = 12
    OPT_ALLOW_IMAGE_RESCALING = 13
    OPT_WM_QUANTIZE_TO_LINE_LENGTH_MULTIPLE = 14
    OPT_ENABLE_HOLD_TRAIL_TEST_MODE = 15
    OPT_SEND_PPS_WITH_COMPRESSED_VIDEO = 16
    OPT_ENABLE_DSI_SCRAMBLING = 17

    # DCS Write Memory BMP decode formats
    FMT_RGB565_16 = 1
    FMT_RGB666_18 = 2
    FMT_RGB666_24 = 3
    FMT_RGB888_24 = 4
    FMT_YCBCR_420_12 = 11
    FMT_YCBCR_422_16 = 13
    FMT_RGB101010_30 = 23
    FMT_RGB121212_36 = 24
    FMT_YCBCR_422_LOOSE_20 = 25
    FMT_YCBCR_422_24 = 26
    FMT_DSC_COMPRESSED = 33

    # MIPI standard cmd masks
    DSI_CMD_MASK = 0x400
    CSI_CMD_MASK = 0x500

    # DPhy timing parameters
    DPHY_PARAM_HS_PREPARE = 0
    DPHY_PARAM_HS_ZERO = 1
    DPHY_PARAM_HS_TRAIL = 2
    DPHY_PARAM_HS_EXIT = 3

    DPHY_PARAM_CLK_PREPARE = 4
    DPHY_PARAM_CLK_ZERO = 5
    DPHY_PARAM_CLK_TRAIL = 6
    DPHY_PARAM_CLK_PRE = 7
    DPHY_PARAM_CLK_POST = 8

    DPHY_PARAM_TA_GO = 9
    DPHY_PARAM_TA_GET = 10
    DPHY_PARAM_WAKEUP = 11

    # Blanking modes
    AUTO_BLANK_MODE = 0
    LP11_BLANK_MODE = 1
    HS_BLANK_MODE = 2

    # trigger commands for ASSERT_PROBE_TRIG and FORCE_PROBE_TRIG
    TRIG_CMD_LOW = 1
    TRIG_CMD_HIGH = 2
    TRIG_CMD_TOGGLE = 3
    TRIG_CMD_PULSE = 4


    ##########################
    # DSI commands 
    # 
    # Note: the command values defined here are applicable when
    # using these command codes in RPC calls via the 
    # PGRemoteRPCClient DLL.  All DSI commands will have 0x400
    # and all CSI commands will have 0x500 added to them
    # (to make them unique across standards).
    ##########################

    # 0 argument commands
    VSYNC_START = 0x401
    VSYNC_END = 0x411
    HSYNC_START = 0x421
    HSYNC_END = 0x431
    EOT_PKT = 0x408
    COLOR_MODE_OFF = 0x402
    COLOR_MODE_ON = 0x412
    SHUT_DOWN_PERIPHERAL = 0x422
    TURN_ON_PERIPHERAL = 0x432
    DCS_READ = 0x406

    # arg1 = ParamCnt (0, 1, 2)
    # arg2 = Param1[7:0]
    # arg3 = Param2[7:0]
    GENERIC_SHORT_WRITE = 0x403

    # arg1 = ParamCnt (0, 1, 2)
    # arg2 = Param1[7:0]
    # arg3 = Param2[7:0]
    GENERIC_READ = 0x404

    # arg1 = ParamCnt (0, 1)
    # arg2 = Params[7:0]
    # (see DCS short write commands)
    DCS_SHORT_WRITE = 0x405

    # arg1 = MaxReturnPktSize[15:0]
    SET_MAX_RETURN_PKT_SIZE = 0x437

    # arg1 = Mode[15:0]
    SCRAMBLING_MODE = 0x427

    # arg1 = WriteLen
    DSI_NULL_PKT = 0x409

    # arg1 = WriteLen
    DSI_BLANKING_PKT = 0x419

    # option1: non-zero length payload array
    # option2: filename 
    GENERIC_LONG_WRITE = 0x429

    # (see DCS long write commands)
    DCS_LONG_WRITE = 0x439

    # arg1 = FrameCnt
    # arg2 = Interlaced (0 == not interlaced, 1 == interlaced only applies to YCBCR formats)
    # option1: non-zero length payload array
    # (length = FrameCnt * HTotal * HVTotal * bytesPerPix)
    # option2: filename 
    PACKED_PIXEL_STREAM_565 = 0x40e
    PACKED_PIXEL_STREAM_666 = 0x41e
    LOOSE_PIXEL_STREAM_666 = 0x42e
    PACKED_PIXEL_STREAM_888 = 0x43e
    LOOSE_PIXEL_STREAM_20_YCBCR_422 = 0x40c
    PACKED_PIXEL_STREAM_24_YCBCR_422 = 0x41c
    PACKED_PIXEL_STREAM_16_YCBCR_422 = 0x42c
    PACKED_PIXEL_STREAM_101010 = 0x40d
    PACKED_PIXEL_STREAM_121212 = 0x41d
    PACKED_PIXEL_STREAM_12_YCBCR_420 = 0x43d

    # option1: non-zero length payload array
    # option2: non-empty filename 
    COMPRESSED_PIXEL_STREAM = 0x40b

    # arg1 = Data 0
    # arg2 = Data 1
    COMPRESSION_MODE = 0x407

    # option1: non-zero length payload array
    # option2: non-empty filename 
    PICTURE_PARAMETER_SET = 0x40a

    # No arguments
    EXECUTE_QUEUE = 0x416

    ##########################
    # CSI commands
    #
    # Note: the command values defined here are applicable when
    # using these command codes in RPC calls via the 
    # PGRemoteRPCClient DLL.  All DSI commands will have 0x400
    # and all CSI commands will have 0x500 added to them
    # (to make them unique across standards).
    ##########################

    # arg1 = FrameNum[15:0]
    FRAME_START = 0x500
    FRAME_END = 0x501

    # arg1 = LineNum[15:0]
    LINE_START = 0x502
    LINE_END = 0x503

    # arg1 = Value[15:0]
    GENERIC_SHORT_PKT1 = 0x508
    GENERIC_SHORT_PKT2 = 0x509
    GENERIC_SHORT_PKT3 = 0x50a
    GENERIC_SHORT_PKT4 = 0x50b
    GENERIC_SHORT_PKT5 = 0x50c
    GENERIC_SHORT_PKT6 = 0x50d
    GENERIC_SHORT_PKT7 = 0x50e
    GENERIC_SHORT_PKT8 = 0x50f

    # arg1 = WriteLen
    CSI_NULL_PKT = 0x510
    CSI_BLANKING_PKT = 0x511

    # option1: non-zero length payload array
    # option2: filename 
    CSI_LONG_PKT = 0x512

    # arg1 = FrameCnt
    # option1: non-zero length payload array
    # (length = FrameCnt * HTotal * HVTotal * bytesPerPix)
    # option2: filename 
    #
    # A special filename of "USERFRAME<n>" can be used to reference
    # internal frame buffers loaded with the LOAD_FRAME command, where
    # <n> is 0 to 3.  When "USERFRAME<n>" is used as the filename,
    # arg1 = byte offset in frame buffer
    # arg2 = byte length of packet
    PIXEL_STREAM_YUV420L_8 = 0x51A
    PIXEL_STREAM_YUV422_8 = 0x51E
    PIXEL_STREAM_YUV422_10 = 0x51F
    PIXEL_STREAM_RGB444 = 0x520
    PIXEL_STREAM_RGB555 = 0x521
    PIXEL_STREAM_RGB565 = 0x522
    PIXEL_STREAM_RGB666 = 0x523
    PIXEL_STREAM_RGB888 = 0x524
    PIXEL_STREAM_RAW6 = 0x528
    PIXEL_STREAM_RAW7 = 0x529
    PIXEL_STREAM_RAW8 = 0x52A
    PIXEL_STREAM_RAW10 = 0x52B
    PIXEL_STREAM_RAW12 = 0x52C
    PIXEL_STREAM_RAW14 = 0x52D

    # option1: non-zero length payload array
    # option2: filename 
    USER_8BIT_TYPE1 = 0x530
    USER_8BIT_TYPE2 = 0x531
    USER_8BIT_TYPE3 = 0x532
    USER_8BIT_TYPE4 = 0x533
    USER_8BIT_TYPE5 = 0x534
    USER_8BIT_TYPE6 = 0x535
    USER_8BIT_TYPE7 = 0x536
    USER_8BIT_TYPE8 = 0x537

    # arg1 = FrameCnt
    # arg2 = User DataType
    # option1: non-zero length payload array
    # option2: filename 
    RAW_COMPRESSED_10_8_10 = 0x5f4
    RAW_COMPRESSED_10_7_10 = 0x5f5
    RAW_COMPRESSED_10_6_10 = 0x5f6
    RAW_COMPRESSED_12_8_12 = 0x5f7
    RAW_COMPRESSED_12_7_12 = 0x5f8
    RAW_COMPRESSED_12_6_12 = 0x5f9

    ##########################
    # DPHY and generic commands
    # NOTE: these correspond to NON_PKT_TYPE defines in DSIToPG class + 0x100
    ##########################
    # no arguments
    SEND_BTA = 0x102
    RESET_TRIGGER = 0x104
    TRIGGER1 = 0x105
    TRIGGER2 = 0x106
    TRIGGER3 = 0x107

    # arg1 = CmdByte[7:0]
    ESCAPE = 0x108

    # arg1 = delay in ns
    # arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    LP_DELAY = 0x109

    # arg1 = LaneMask[4:0]
    ULPS = 0x10a

    # no arguments
    WAIT_FOR_BTA = 0x10c
    CLOCK_ON = 0x10d
    CLOCK_OFF = 0x10e

    # waits for input event
    # arg1 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    WAIT_EXT_EVENT = 0x110

    # Defines a command insertion point when used in looping macro
    # arg1 = delay in ns
    # arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    # arg3 = discard flag (0 == suspend program while inserting 1 == discard input while inserting)
    CMD_INSERTION_POINT = 0x112

    # Asserts TrigOut on the instrument 
    # NOTE: this is for probe trigger control during the command 
    # (use FORCE_TRIG command to affect TrigOut immediately)
    # arg1 = delay in ns
    # arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    # arg3 = trigger command: 0 (low voltage), 1 (high voltage), 2 (toggle voltage), 3 (pulse voltage)
    # Note: Toggle command starts from current voltage (i.e. may be low->high or high->low)
    # Note: Pulse command starts from current voltage (i.e. may be low->high->low or high->low->high)
    # Use SET_TRIG_DURATION command to set the pulse width
    ASSERT_TRIG = 0x113

    # Asserts LP state (and possibly HS clock state) onto the bus until the specified position
    # in the current macro.  The delay parameter is interpreted relative to the "zero position"
    # as indicated by the last call (in the macro) of MARK_ZERO_POS.  If there is no last
    # call to MARK_ZERO_POS, the start of the macro is used.  
    #
    # arg1 = delay in ns
    # arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    LP_DELAY_TO_POS = 0x114

    # no arguments
    # Records the current position when compiling a macro to use as a time reference
    # (Subsequent calls to LP_DELAY_TO_POS use this "zero position" as the reference
    # to allow exact timing for constructing video lines).
    MARK_ZERO_POS = 0x115

    # arg1 = seed (int, applies to all lanes)
    # arg2 = WordCnt (int)
    PRBS9_SEQ = 0x116
    PRBS11_SEQ = 0x117
    PRBS18_SEQ = 0x118

    # arg1 = LoopCnt (int)
    # Params[] contained in non-zero length payload array
    TGR_DATA_SEQ = 0x119
    TGR_BIT_SEQ = 0x11a

    # non-null filename 
    FILE_COMMAND = 0x11c

    # arg1 = duration (UI, int)
    SKEW_CALIBRATION = 0x11d

    # Same as LP_DELAY with UI units
    # arg1 = duration (UI, int)
    # arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    LP_DELAY_UI = 0x11e

    # Same as LP_DELAY_TO_POS with UI units
    # arg1 = duration (UI, int)
    # arg2 = LPValue[7:0] (4 lanes, 2-bits used per LP State)
    LP_DELAY_TO_POS_UI = 0x11f

    # arg1 = loop iterations
    LOOP_START = 0x120

    # no arguments
    LOOP_END = 0x121

    # no arguments provide non-null filename
    PG_FILE = 0x122

    # arg1 = ParamCnt (1, 2)
    # arg2 = Parameter byte 1 
    # arg3 = Parameter byte 2 (if necessary)
    GENERIC_SHORT_READ_RESPONSE = 0x1f5

    # option1: non-zero length payload array
    # option2: filename 
    GENERIC_LONG_READ_RESPONSE = 0x1f6

    # arg1 = ParamCnt (1, 2)
    # arg2 = Parameter byte 1 
    # arg3 = Parameter byte 2 (if necessary)
    DCS_SHORT_READ_RESPONSE = 0x1f7

    # option1: non-zero length payload array
    # option2: filename 
    DCS_LONG_READ_RESPONSE = 0x1f8

    # arg1 = ErrorBits[15:0]
    ACK_AND_ERROR_REPORT = 0x1f9

    # arg1 = DataID
    # data block with command data
    CUSTOM_LONG_COMMAND = 0x1fa

    # arg1 = DataID
    # data block with command data
    CUSTOM_COMMAND = 0x1fc

    # arg1: filename
    RPC_SCRIPT = 0x1fd

    ########################
    # DCS_SHORT_WRITE cmd types
    ########################

    # 0 argument commands
    ENTER_IDLE_MODE = 0x39
    ENTER_INVERT_MODE = 0x21
    ENTER_NORMAL_MODE = 0x13
    ENTER_PARTIAL_MODE = 0x12
    ENTER_SLEEP_MODE = 0x10
    EXIT_IDLE_MODE = 0x38
    EXIT_INVERT_MODE = 0x20
    EXIT_SLEEP_MODE = 0x11
    NOP = 0
    SET_DISPLAY_OFF = 0x28
    SET_DISPLAY_ON = 0x29
    SET_TEAR_OFF = 0x34
    SOFT_RESET = 0x01

    # arg1 = Mode[7:0]
    SET_ADDRESS_MODE = 0x36

    # arg1 = Mode[7:0]
    SET_3D_CONTROL = 0x3d

    # arg1 = GammaCurve[7:0]
    SET_GAMMA_CURVE = 0x26

    # arg1 = Format[7:0]
    SET_PIXEL_FORMAT = 0x3a

    # arg1 = M[0]
    SET_TEAR_ON = 0x35

    # arg1 = Timing[7:0]
    SET_VSYNC_TIMING = 0x40

    # arg1 = Ctl[7:0]
    WRITE_CONTROL_DISPLAY = 0x53

    # arg1 = PS[7:0]
    WRITE_POWER_SAVE = 0x55

    ########################
    # DCS_READ cmd types
    ########################

    GET_ADDRESS_MODE = 0x0b
    GET_3D_CONTROL = 0x3f
    GET_COMPRESSION_MODE = 0x03
    GET_BLUE_CHANNEL = 0x08
    GET_DIAGNOSTIC_RESULT = 0x0f
    GET_DISPLAY_MODE = 0x0d
    GET_GREEN_CHANNEL = 0x07
    GET_PIXEL_FORMAT = 0x0c
    GET_POWER_MODE = 0x0a
    GET_RED_CHANNEL = 0x06
    GET_SCANLINE = 0x45
    GET_SIGNAL_MODE = 0x0e
    READ_DDB_CONTINUE = 0xa8
    READ_DDB_START = 0xa1
    READ_MEMORY_CONTINUE = 0x3e
    READ_MEMORY_START = 0x2e
    READ_PPS_CONTINUE = 0xa9
    READ_PPS_START = 0xa2

    GET_CABC_MIN_BRIGHTNESS = 0x5f
    GET_CONTROL_DISPLAY = 0x54
    GET_DISPLAY_BRIGHTNESS = 0x52
    GET_ERROR_COUNT_ON_DSI = 0x05
    GET_IMAGE_CHECKSUM_CT = 0x15
    GET_IMAGE_CHECKSUM_RGB = 0x14
    GET_POWER_SAVE = 0x56

    ########################
    # DCS_LONG_WRITE cmd types
    ########################

    # arg1 = VertScrollPtr[15:0]
    SET_SCROLL_START = 0x37

    # arg1 = Line[15:0]
    SET_TEAR_SCANLINE = 0x44

    # arg1 = StartColumn[15:0]
    # arg2 = EndColumn[15:0]
    SET_COLUMN_ADDRESS = 0x2a

    # arg1 = StartPage[15:0]
    # arg2 = EndPage[15:0]
    SET_PAGE_ADDRESS = 0x2b

    # arg1 = StartRow[15:0]
    # arg2 = EndRow[15:0]
    SET_PARTIAL_ROWS = 0x30

    # arg1 = StartCol[15:0]
    # arg2 = EndCol[15:0]
    SET_PARTIAL_COLUMNS = 0x31

    # arg1 = TopFixedArea[15:0]
    # arg2 = VertScrollArea[15:0]
    # arg3 = BotFixedArea[15:0]
    SET_SCROLL_AREA = 0x33

    # arg1 = Brightness[15:0]
    SET_CABC_MIN_BRIGHTNESS = 0x5e

    # arg1 = Brightness[15:0]
    SET_DISPLAY_BRIGHTNESS = 0x51

    # option1: non-zero length payload array
    # option2: filename 
    WRITE_LUT = 0x2d

    # arg1 = FileOffset
    # arg2 = WriteLen
    # option1: non-zero length payload array
    #          (FileOffset and WriteLen are ignored)
    # option2: filename 
    WRITE_MEMORY_CONTINUE = 0x3c

    # arg1 = FileOffset
    # arg2 = WriteLen
    # option1: non-zero length payload array
    #          (FileOffset and WriteLen are ignored)
    # option2: filename 
    WRITE_MEMORY_START = 0x2c

