#pragma once

using namespace System;

static unsigned char *ConvertBAToUnmanaged(array<Byte>^ ba);
static char *ConvertStringToUnmanaged(String^ str);
static array<Byte> ^ConvertBAToManaged(unsigned char* buf, int len);
static String ^ConvertStringToManaged(char* str);

class DPhyGenCtlRPCPrivateWrapper;

class __declspec(dllexport) DPhyGenCtlRPCWrapper
{
private: 
	DPhyGenCtlRPCPrivateWrapper* m_privateWrapper;
	char* m_lastErrMsg;
	char* m_lastStatusMsg;

public: 
	DPhyGenCtlRPCWrapper();
	~DPhyGenCtlRPCWrapper();

	// if copy is true, use FreeString to deallocate
	// if copy is false, string is valid until next GUI call 
	char* DPhyGenCtlRPCWrapper::GetLastErrMsg(bool copy);
	char* DPhyGenCtlRPCWrapper::GetLastStatusMsg(bool copy);
	void DPhyGenCtlRPCWrapper::Free(void* ptr);
	int DPhyGenCtlRPCWrapper::UpdateMsgs(int rc);

	int DPhyGenCtlRPCWrapper::Connect(const char* hostName, int port);
	void DPhyGenCtlRPCWrapper::Disconnect();
	int DPhyGenCtlRPCWrapper::RPCCmd(int cmdCode);
	int DPhyGenCtlRPCWrapper::RPCCmdI(int cmdCode, int arg1);
	int DPhyGenCtlRPCWrapper::RPCCmdF(int cmdCode, float arg1);
	int DPhyGenCtlRPCWrapper::RPCCmdS(int cmdCode, const char* arg1);
	int DPhyGenCtlRPCWrapper::RPCCmdII(int cmdCode, int arg1, int arg2);
	int DPhyGenCtlRPCWrapper::RPCCmdIF(int cmdCode, int arg1, float arg2);
	int DPhyGenCtlRPCWrapper::RPCCmdIS(int cmdCode, int arg1, const char* arg2);
	int DPhyGenCtlRPCWrapper::RPCCmdIII(int cmdCode, int arg1, int arg2, int arg3);
	int DPhyGenCtlRPCWrapper::RPCCmdIIS(int cmdCode, int arg1, int arg2, const char* arg3);
	int DPhyGenCtlRPCWrapper::RPCCmdSIS(int cmdCode, const char* arg1, int arg2, const char* arg3);
	int DPhyGenCtlRPCWrapper::RPCCmdIIBA(int cmdCode, int arg1, int arg2, unsigned char* arg3, int arg3Len );
	int DPhyGenCtlRPCWrapper::RPCCmdIISS(int cmdCode, int arg1, int arg2, const char* arg3, const char* arg4);
	int DPhyGenCtlRPCWrapper::RPCCmdSISI(int cmdCode, const char* arg1, int arg2, const char* arg3, int arg4);
	int DPhyGenCtlRPCWrapper::RPCQueryIRetS(int cmdCode, int arg1, char** respVal);
	int DPhyGenCtlRPCWrapper::RPCQuerySRetS(int cmdCode, const char* arg1, char** respVal);
	int DPhyGenCtlRPCWrapper::RPCQueryRetBA(int cmdCode, unsigned char** respVal, int* respValLen);
	int DPhyGenCtlRPCWrapper::RPCQueryRetIA(int cmdCode, int** respVal, int* respValLen);

	int DPhyGenCtlRPCWrapper::MIPICmd(int cmdCode, int DCSCmdCode, bool BTA, int DTMode,
		int VC, int arg1, int arg2, int arg3, const char* fn, unsigned char* data, int dataLen);
};
