﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using DPhyGenCtlRPC;

namespace CSIVideoPlayer
{
    public class CSI
    {
        public static int[] Formats = new int[] { 0x20, 0x21, 0x22, 0x23, 0x24, 0x28, 0x29, 
                                               0x2A, 0x2B, 0x2c, 0x2d, 0x1e, 0x1f, 0x1a };

        public const int PIXEL_STREAM_YUV420_8 = 0x18;
        public const int PIXEL_STREAM_YUV420_10 = 0x19;
        public const int PIXEL_STREAM_YUV420L_8 = 0x1A;
        public const int PIXEL_STREAM_YUV420S_8 = 0x1C;
        public const int PIXEL_STREAM_YUV420S_10 = 0x1D;
        public const int PIXEL_STREAM_YUV422_8 = 0x1E;
        public const int PIXEL_STREAM_YUV422_10 = 0x1F;

        public const int PIXEL_STREAM_RGB444 = 0x20;
        public const int PIXEL_STREAM_RGB555 = 0x21;
        public const int PIXEL_STREAM_RGB565 = 0x22;
        public const int PIXEL_STREAM_RGB666 = 0x23;
        public const int PIXEL_STREAM_RGB888 = 0x24;

        public const int PIXEL_STREAM_RAW6 = 0x28;
        public const int PIXEL_STREAM_RAW7 = 0x29;
        public const int PIXEL_STREAM_RAW8 = 0x2A;
        public const int PIXEL_STREAM_RAW10 = 0x2B;
        public const int PIXEL_STREAM_RAW12 = 0x2C;
        public const int PIXEL_STREAM_RAW14 = 0x2D;

        public static string CSIVideoCmdString(int cmdCode)
        {
            switch (cmdCode)
            {
                case CSI.PIXEL_STREAM_RAW6:
                    return ("Raw6");
                case CSI.PIXEL_STREAM_RAW7:
                    return ("Raw7");
                case CSI.PIXEL_STREAM_RAW8:
                    return ("Raw8");
                case CSI.PIXEL_STREAM_RAW10:
                    return ("Raw10");
                case CSI.PIXEL_STREAM_RAW12:
                    return ("Raw12");
                case CSI.PIXEL_STREAM_RAW14:
                    return ("Raw14");
                case CSI.PIXEL_STREAM_RGB444:
                    return ("RGB 444");
                case CSI.PIXEL_STREAM_RGB555:
                    return ("RGB 555");
                case CSI.PIXEL_STREAM_RGB565:
                    return ("RGB 565");
                case CSI.PIXEL_STREAM_RGB666:
                    return ("RGB 666");
                case CSI.PIXEL_STREAM_RGB888:
                    return ("RGB 888");
                case CSI.PIXEL_STREAM_YUV420_8:
                    return ("YUV 8-bit 420");
                case CSI.PIXEL_STREAM_YUV420_10:
                    return ("YUV 10-bit 420");
                case CSI.PIXEL_STREAM_YUV420S_8:
                    return ("YUV 8-bit 420 (Shifted)");
                case CSI.PIXEL_STREAM_YUV420S_10:
                    return ("YUV 10-bit 420 (Shifted)");
                case CSI.PIXEL_STREAM_YUV420L_8:
                    return ("YUV_8-bit 420 (Legacy)");
                case CSI.PIXEL_STREAM_YUV422_8:
                    return ("YUV 8-bit 422");
                case CSI.PIXEL_STREAM_YUV422_10:
                    return ("YUV 10-bit 422");
                default:
                    return ("");
            }

            return ("");
        }

        public static int CSIVideoCmdBitsPerPixel(int cmdCode)
        {
            switch (cmdCode)
            {
                case CSI.PIXEL_STREAM_RAW6:
                    return (6);
                case CSI.PIXEL_STREAM_RAW7:
                    return (7);
                case CSI.PIXEL_STREAM_RAW8:
                    return (8);
                case CSI.PIXEL_STREAM_RAW10:
                    return (10);
                case CSI.PIXEL_STREAM_RAW12:
                    return (12);
                case CSI.PIXEL_STREAM_RAW14:
                    return (14);
                case CSI.PIXEL_STREAM_RGB444:
                    return (16);
                case CSI.PIXEL_STREAM_RGB555:
                    return (16);
                case CSI.PIXEL_STREAM_RGB565:
                    return (16);
                case CSI.PIXEL_STREAM_RGB666:
                    return (18);
                case CSI.PIXEL_STREAM_RGB888:
                    return (24);
                case CSI.PIXEL_STREAM_YUV420_8:  // avg
                    return (12);
                case CSI.PIXEL_STREAM_YUV420_10: // avg
                    return (15);
                case CSI.PIXEL_STREAM_YUV420S_8: // avg
                    return (12);
                case CSI.PIXEL_STREAM_YUV420S_10: // avg
                    return (15);
                case CSI.PIXEL_STREAM_YUV420L_8: // avg
                    return (12);
                case CSI.PIXEL_STREAM_YUV422_8:  // avg
                    return (16);
                case CSI.PIXEL_STREAM_YUV422_10: // avg
                    return (20);
                default:
                    return (0);
            }

            return (0);
        }

        public static int CSIVideoCmdToRPCCmd(int cmdCode)
        {
            switch (cmdCode)
            {
                case CSI.PIXEL_STREAM_RAW6:
                    return (RPCDefs.PIXEL_STREAM_RAW6);
                case CSI.PIXEL_STREAM_RAW7:
                    return (RPCDefs.PIXEL_STREAM_RAW7);
                case CSI.PIXEL_STREAM_RAW8:
                    return (RPCDefs.PIXEL_STREAM_RAW8);
                case CSI.PIXEL_STREAM_RAW10:
                    return (RPCDefs.PIXEL_STREAM_RAW10);
                case CSI.PIXEL_STREAM_RAW12:
                    return (RPCDefs.PIXEL_STREAM_RAW12);
                case CSI.PIXEL_STREAM_RAW14:
                    return (RPCDefs.PIXEL_STREAM_RAW14);
                case CSI.PIXEL_STREAM_RGB444:
                    return (RPCDefs.PIXEL_STREAM_RGB444);
                case CSI.PIXEL_STREAM_RGB555:
                    return (RPCDefs.PIXEL_STREAM_RGB555);
                case CSI.PIXEL_STREAM_RGB565:
                    return (RPCDefs.PIXEL_STREAM_RGB565);
                case CSI.PIXEL_STREAM_RGB666:
                    return (RPCDefs.PIXEL_STREAM_RGB666);
                case CSI.PIXEL_STREAM_RGB888:
                    return (RPCDefs.PIXEL_STREAM_RGB888);
                case CSI.PIXEL_STREAM_YUV420L_8:
                    return (RPCDefs.PIXEL_STREAM_YUV420L_8);
                case CSI.PIXEL_STREAM_YUV422_8:
                    return (RPCDefs.PIXEL_STREAM_YUV422_8);
                case CSI.PIXEL_STREAM_YUV422_10:
                    return (RPCDefs.PIXEL_STREAM_YUV422_10);
                default:
                    return (0);
            }

            return (0);
        }

    }

    public class DSI
    {
        public static int[] Formats = new int[] { 0x0e, 0x1e, 0x2e, 0x3e, 0x0d, 0x1d, 0x3d, 0x0c, 0x1c, 0x2c };

        public const int LOOSE_PIXEL_STREAM_20_YCBCR_422 = 0x0c;
        public const int PACKED_PIXEL_STREAM_24_YCBCR_422 = 0x1c;
        public const int PACKED_PIXEL_STREAM_16_YCBCR_422 = 0x2c;
        public const int PACKED_PIXEL_STREAM_101010 = 0x0d;
        public const int PACKED_PIXEL_STREAM_121212 = 0x1d;
        public const int PACKED_PIXEL_STREAM_12_YCBCR_420 = 0x3d;

        public const int PACKED_PIXEL_STREAM_565 = 0x0e;
        public const int PACKED_PIXEL_STREAM_666 = 0x1e;
        public const int LOOSE_PIXEL_STREAM_666 = 0x2e;
        public const int PACKED_PIXEL_STREAM_888 = 0x3e;

        public static int DSIVideoCmdBitPerPixel(int cmdCode)
        {
            if (cmdCode == DSI.PACKED_PIXEL_STREAM_565)
                    return (16);
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_666)
                    return (18);
            else if (cmdCode == DSI.LOOSE_PIXEL_STREAM_666)
                    return (24);
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_888)
                    return (24);
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_101010)
                    return (30);
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_121212)
                    return (36);
            else if (cmdCode == DSI.LOOSE_PIXEL_STREAM_20_YCBCR_422) // avg
                    return (20);
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_16_YCBCR_422) // avg
                    return (16);
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_24_YCBCR_422) // avg
                    return (24);
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_12_YCBCR_420) // avg
                return (12);
            else
                return 0;
        }

        public static string DSIVideoCmdString(int cmdCode)
        {
            if (cmdCode == DSI.PACKED_PIXEL_STREAM_565)
                return ("Packed RGB 565");
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_666)
                return ("Packed RGB 666");
            else if (cmdCode == DSI.LOOSE_PIXEL_STREAM_666)
                return ("Loose RGB 666");
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_888)
                return ("Packed RGB 888");
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_101010)
                return ("Packed RGB 101010");
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_121212)
                return ("Packed RGB 121212");
            else if (cmdCode == DSI.LOOSE_PIXEL_STREAM_20_YCBCR_422)
                return ("Loose 20-bit YCbCr 422");
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_16_YCBCR_422)
                return ("Packed 16-bit YCbCr 422");
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_24_YCBCR_422)
                return ("Packed 24-bit YCbCr 422");
            else if (cmdCode == DSI.PACKED_PIXEL_STREAM_12_YCBCR_420)
                return ("Packed 12-bit YCbCr 420");
            else
                return "";
        }
    }

    [Serializable]
    public class Settings
    {
        public const int SEQ_SINGLE_FRAME = 0;
        public const int SEQ_SEQUENTIAL_FRAMES = 1;
        public const int SEQ_CONCENTRIC_SEQUENTIAL_FRAMES = 2;
        public const int SEQ_CONCENTRIC_INTERLEAVED_FRAMES = 3;

        // user-settings
        public int port = 2799;
        public int laneCnt = 1;
        public int seqFormat = SEQ_SINGLE_FRAME;
        public bool equalLines = true;
        public bool separateFSFE = false;
        public bool quantLineLength = true;
        public bool clockOffDuringBlanking = true;
        public bool loopFrames = true;
        public float hsFreq = 100e+6f;

        // per-frame user-settings
        public int[] vblank = new int[] { 45, 45 };
        public int[] vact = new int[] { 480, 480 };
        public int[] hblank = new int[] { 160, 160 };
        public int[] hact = new int[] { 640, 640 };
        public int[] videoFormat = new int[] { CSI.PIXEL_STREAM_RGB888, CSI.PIXEL_STREAM_RGB888 };
        public int[] VC = new int[] { 0, 0 };
        public bool[] UseLSLE = new bool[] { true, true };
        public string[] imageFn = new string[] { "ramp_3", "ramp_3" };

        // derived settings
        public int frameCnt;
        public int shortPktUIPerLane;
        public int clkOnUIPerLane;
        public int clkOffUIPerLane;

        // per-frame derived settings
        public int[] rpcVideoCmd = new int[2];
        public int[] bitsPerPix = new int[2];
        public int[] bitsPerLine = new int[2];
        public int[] bytesPerLinePerLane = new int[2];
        public int[] activeLineLenInBytes = new int[2];

        // NOTE: if you add fields to this class, make sure you 
        // add them at the end and use the modifier:
        // [OptionalField(VersionAdded = <x>)]
        // so that existing configuration files will load.
        //
        // For example:
        // [OptionalField(VersionAdded = 2)]
        // public int newField;

    };
}

