﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Windows.Forms;
using System.Drawing;
using Utils.MessageBoxExLib;

namespace CustomClasses
{
    public class MsgBox
    {
        public static Color m_backColor = Color.Beige;
        public static Color m_foreColor = Color.Black;
        public static Color m_buttonBackColor = Color.Beige;
        public static Color m_buttonForeColor = Color.Black;

        public static bool m_autoResponseEnable = false;
        public static bool m_autoResponse = true;

        public const int INFORMATION = 0;
        public const int WARNING = 1;
        public const int ERROR = 2;
        public const int QUESTION = 3;

        private static Utils.MessageBoxExLib.MessageBoxExIcon GetIcon(int type)
        {
            switch (type)
            {
                case INFORMATION:
                    return Utils.MessageBoxExLib.MessageBoxExIcon.Information;
                case WARNING:
                    return Utils.MessageBoxExLib.MessageBoxExIcon.Warning;
                case ERROR:
                    return Utils.MessageBoxExLib.MessageBoxExIcon.Error;
                case QUESTION:
                    return Utils.MessageBoxExLib.MessageBoxExIcon.Question;
                default:
                    return Utils.MessageBoxExLib.MessageBoxExIcon.Information;
            }
        }

        public static void OK(string msg)
        {
            OK(msg, "", INFORMATION);
        }

        public static void OK(string msg, string title)
        {
            OK(msg, title, INFORMATION);
        }

        public static void OK(string msg, string title, int iconType)
        {
            if (m_autoResponseEnable) return;

            MessageBoxEx mbox = MessageBoxExManager.CreateMessageBox(null);
            mbox.Caption = title;
            mbox.Text = msg;
            mbox.Icon = GetIcon(iconType);
            mbox.BackColor = m_backColor;
            mbox.ForeColor = m_foreColor;
            MessageBoxExButton button = new MessageBoxExButton();
            button.Text = "OK";
            button.Value = "OK";
            button.BackColor = m_buttonBackColor;
            button.ForeColor = m_buttonForeColor;
            mbox.AddButton(button);
            string result = mbox.Show();
            return;
        }

        public static bool OKCancel(string msg)
        {
            return (OKCancel(msg, "", INFORMATION));
        }

        public static bool OKCancel(string msg, string title)
        {
            return (OKCancel(msg, title, INFORMATION));
        }

        public static bool OKCancel(string msg, string title, int iconType)
        {
            if (m_autoResponseEnable) return (m_autoResponse);

            MessageBoxEx mbox = MessageBoxExManager.CreateMessageBox(null);
            mbox.Caption = title;
            mbox.Text = msg;
            mbox.Icon = GetIcon(iconType);
            mbox.BackColor = m_backColor;
            mbox.ForeColor = m_foreColor;
            MessageBoxExButton button = new MessageBoxExButton();
            button.Text = "OK";
            button.Value = "OK";
            button.BackColor = m_buttonBackColor;
            button.ForeColor = m_buttonForeColor;
            mbox.AddButton(button);
            button = new MessageBoxExButton();
            button.Text = "Cancel";
            button.Value = "Cancel";
            button.BackColor = m_buttonBackColor;
            button.ForeColor = m_buttonForeColor;
            button.IsCancelButton = true;
            mbox.AddButton(button);
            string result = mbox.Show();
            return (result == "OK");
        }

        public static bool YesNo(string msg)
        {
            return (YesNo(msg, "", INFORMATION));
        }

        public static bool YesNo(string msg, string title)
        {
            return (YesNo(msg, title, INFORMATION));
        }

        public static bool YesNo(string msg, string title, int iconType)
        {
            if (m_autoResponseEnable) return (m_autoResponse);

            MessageBoxEx mbox = MessageBoxExManager.CreateMessageBox(null);
            mbox.Caption = title;
            mbox.Text = msg;
            mbox.Icon = GetIcon(iconType);
            mbox.BackColor = m_backColor;
            mbox.ForeColor = m_foreColor;
            MessageBoxExButton button = new MessageBoxExButton();
            button.Text = "Yes";
            button.Value = "Yes";
            button.BackColor = m_buttonBackColor;
            button.ForeColor = m_buttonForeColor;
            mbox.AddButton(button);
            button = new MessageBoxExButton();
            button.Text = "No";
            button.Value = "No";
            button.BackColor = m_buttonBackColor;
            button.ForeColor = m_buttonForeColor;
            button.IsCancelButton = true;
            mbox.AddButton(button);
            string result = mbox.Show();
            return (result == "Yes");
        }
    }

}
